/*
 * Decompiled with CFR 0.152.
 */
package org.openl.security.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openl.rules.security.SimplePrivilege;
import org.openl.rules.security.SimpleUser;
import org.openl.util.StringUtils;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public class SAMLAttributesToOpenLUserDetailsService
implements SAMLUserDetailsService {
    private final String usernameAttribute;
    private final String firstNameAttribute;
    private final String lastNameAttribute;
    private final String groupsAttribute;
    private final GrantedAuthoritiesMapper authoritiesMapper;

    public SAMLAttributesToOpenLUserDetailsService(String usernameAttribute, String firstNameAttribute, String lastNameAttribute, String groupsAttribute, GrantedAuthoritiesMapper authoritiesMapper) {
        this.usernameAttribute = usernameAttribute;
        this.firstNameAttribute = firstNameAttribute;
        this.lastNameAttribute = lastNameAttribute;
        this.groupsAttribute = groupsAttribute;
        this.authoritiesMapper = authoritiesMapper;
    }

    public Object loadUserBySAML(SAMLCredential credential) throws UsernameNotFoundException {
        String[] names;
        ArrayList<SimplePrivilege> grantedAuthorities = new ArrayList<SimplePrivilege>();
        String username = credential.getNameID().getValue();
        String firstName = null;
        String lastName = null;
        if (StringUtils.isNotBlank((CharSequence)this.usernameAttribute)) {
            username = credential.getAttributeAsString(this.usernameAttribute);
        }
        if (StringUtils.isNotBlank((CharSequence)this.firstNameAttribute)) {
            firstName = credential.getAttributeAsString(this.firstNameAttribute);
        }
        if (StringUtils.isNotBlank((CharSequence)this.lastNameAttribute)) {
            lastName = credential.getAttributeAsString(this.lastNameAttribute);
        }
        if (StringUtils.isNotBlank((CharSequence)this.groupsAttribute) && (names = credential.getAttributeAsStringArray(this.groupsAttribute)) != null) {
            for (String name : names) {
                grantedAuthorities.add(new SimplePrivilege(name, name));
            }
        }
        List privileges = (List)this.authoritiesMapper.mapAuthorities(grantedAuthorities);
        return new SimpleUser(firstName, lastName, username, null, (Collection)privileges);
    }
}

