/*
 * Decompiled with CFR 0.152.
 */
package org.openl.security.saml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.openl.rules.security.Privilege;
import org.openl.rules.security.SimplePrivilege;
import org.openl.rules.security.SimpleUser;
import org.openl.rules.security.User;
import org.openl.util.CollectionUtils;
import org.openl.util.StringUtils;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.env.PropertyResolver;
import org.springframework.security.core.AuthenticatedPrincipal;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.saml2.provider.service.authentication.DefaultSaml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.w3c.dom.Node;

public class OpenLResponseAuthenticationConverter
implements Converter<OpenSaml4AuthenticationProvider.ResponseToken, Saml2Authentication> {
    private final BiFunction<String, Collection<? extends GrantedAuthority>, Collection<Privilege>> privilegeMapper;
    private final Consumer<User> syncUserData;
    private final PropertyResolver propertyResolver;

    public OpenLResponseAuthenticationConverter(PropertyResolver propertyResolver, Consumer<User> syncUserData, BiFunction<String, Collection<? extends GrantedAuthority>, Collection<Privilege>> privilegeMapper) {
        this.propertyResolver = propertyResolver;
        this.syncUserData = syncUserData;
        this.privilegeMapper = privilegeMapper;
    }

    public Saml2Authentication convert(OpenSaml4AuthenticationProvider.ResponseToken responseToken) {
        Assertion assertion = (Assertion)responseToken.getResponse().getAssertions().iterator().next();
        SimpleUserSamlBuilder simpleUserBuilder = new SimpleUserSamlBuilder(this.propertyResolver);
        simpleUserBuilder.setAssertionAttributes(assertion);
        simpleUserBuilder.setNameID(assertion.getSubject().getNameID().getValue());
        SimpleUser simpleUser = simpleUserBuilder.build();
        this.syncUserData.accept((User)simpleUser);
        Collection<Privilege> privileges = this.privilegeMapper.apply(simpleUser.getUsername(), simpleUser.getAuthorities());
        DefaultSaml2AuthenticatedPrincipal principal = new DefaultSaml2AuthenticatedPrincipal(simpleUser.getUsername(), Collections.emptyMap());
        principal.setRelyingPartyRegistrationId(responseToken.getToken().getRelyingPartyRegistration().getRegistrationId());
        return new Saml2Authentication((AuthenticatedPrincipal)principal, responseToken.getToken().getSaml2Response(), privileges);
    }

    private static class SimpleUserSamlBuilder {
        private final String usernameAttribute;
        private final String firstNameAttribute;
        private final String lastNameAttribute;
        private final String groupsAttribute;
        private final String emailAttribute;
        private final String displayNameAttribute;
        private final Map<String, List<String>> fields = new HashMap<String, List<String>>();
        private String username;

        public SimpleUserSamlBuilder(PropertyResolver propertyResolver) {
            this.usernameAttribute = propertyResolver.getProperty("security.saml.attribute.username");
            this.firstNameAttribute = propertyResolver.getProperty("security.saml.attribute.first-name");
            this.lastNameAttribute = propertyResolver.getProperty("security.saml.attribute.last-name");
            this.emailAttribute = propertyResolver.getProperty("security.saml.attribute.email");
            this.groupsAttribute = propertyResolver.getProperty("security.saml.attribute.groups");
            this.displayNameAttribute = propertyResolver.getProperty("security.saml.attribute.display-name");
            this.fields.put(this.usernameAttribute, new ArrayList());
            this.fields.put(this.firstNameAttribute, new ArrayList());
            this.fields.put(this.lastNameAttribute, new ArrayList());
            this.fields.put(this.emailAttribute, new ArrayList());
            this.fields.put(this.groupsAttribute, new ArrayList());
            this.fields.put(this.displayNameAttribute, new ArrayList());
        }

        private void setAssertionAttributes(Assertion assertion) {
            for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
                for (Attribute attribute : attributeStatement.getAttributes()) {
                    if (!this.fields.containsKey(attribute.getName())) continue;
                    ArrayList<String> attributeValues = new ArrayList<String>();
                    for (XMLObject xmlObject : attribute.getAttributeValues()) {
                        String attributeValue = this.getAttributeValue(xmlObject);
                        if (attributeValue == null) continue;
                        attributeValues.add(attributeValue);
                    }
                    this.fields.get(attribute.getName()).addAll(attributeValues);
                }
            }
        }

        public void setNameID(String username) {
            this.username = username;
        }

        public SimpleUser build() {
            ArrayList<SimplePrivilege> grantedAuthorities = new ArrayList<SimplePrivilege>();
            if (StringUtils.isNotBlank((CharSequence)this.groupsAttribute)) {
                for (String name : this.getAttributeValues(this.groupsAttribute)) {
                    grantedAuthorities.add(new SimplePrivilege(name));
                }
            }
            return SimpleUser.builder().setFirstName(this.getAttributeAsString(this.firstNameAttribute)).setLastName(this.getAttributeAsString(this.lastNameAttribute)).setUsername(StringUtils.isBlank((CharSequence)this.usernameAttribute) ? this.username : this.getAttributeAsString(this.usernameAttribute)).setPrivileges(grantedAuthorities).setEmail(this.getAttributeAsString(this.emailAttribute)).setDisplayName(this.getAttributeAsString(this.displayNameAttribute)).build();
        }

        private String getAttributeAsString(String key) {
            List<String> values = this.fields.get(key);
            return CollectionUtils.isNotEmpty(values) ? values.iterator().next() : null;
        }

        private List<String> getAttributeValues(String key) {
            return Collections.unmodifiableList(this.fields.getOrDefault(key, Collections.emptyList()));
        }

        private String getAttributeValue(XMLObject xmlObject) {
            String textContent = xmlObject instanceof XSString ? ((XSString)xmlObject).getValue() : (xmlObject instanceof XSAny ? ((XSAny)xmlObject).getTextContent() : (String)Optional.ofNullable(xmlObject.getDOM()).map(Node::getTextContent).orElse(null));
            return StringUtils.trimToNull((String)textContent);
        }
    }
}

