/*
 * Decompiled with CFR 0.152.
 */
package org.openl.security.saml;

import java.io.ByteArrayInputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Iterator;
import org.openl.util.StringUtils;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertyResolver;
import org.springframework.security.saml2.core.Saml2X509Credential;
import org.springframework.security.saml2.provider.service.registration.InMemoryRelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;

public class LazyInMemoryRelyingPartyRegistrationRepository
implements RelyingPartyRegistrationRepository,
Iterable<RelyingPartyRegistration> {
    private static final Logger log = LoggerFactory.getLogger(LazyInMemoryRelyingPartyRegistrationRepository.class);
    private InMemoryRelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private PropertyResolver propertyResolver;

    public LazyInMemoryRelyingPartyRegistrationRepository(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
        this.init();
    }

    private void init() {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(Base64.getMimeDecoder().decode(this.propertyResolver.getProperty("security.saml.local-key")));
            PrivateKey privateKey = keyFactory.generatePrivate(privateKeySpec);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getMimeDecoder().decode(this.propertyResolver.getProperty("security.saml.local-certificate")));
            X509Certificate localCert = (X509Certificate)certFactory.generateCertificate(in);
            Saml2X509Credential signing = Saml2X509Credential.signing((PrivateKey)privateKey, (X509Certificate)localCert);
            Saml2X509Credential decryption = Saml2X509Credential.decryption((PrivateKey)privateKey, (X509Certificate)localCert);
            RelyingPartyRegistration.Builder registrationBuilder = RelyingPartyRegistrations.fromMetadataLocation((String)this.propertyResolver.getProperty("security.saml.saml-server-metadata-url")).registrationId("webstudio").singleLogoutServiceLocation("{baseUrl}/logout/saml2/slo").entityId(this.propertyResolver.getProperty("security.saml.entity-id")).signingX509Credentials(c -> c.add(signing)).decryptionX509Credentials(c -> c.add(decryption));
            String serverCertificate = this.propertyResolver.getProperty("security.saml.server-certificate");
            if (StringUtils.isNotBlank((CharSequence)serverCertificate)) {
                X509Certificate idpCert = X509Support.decodeCertificate((String)serverCertificate);
                Saml2X509Credential verification = Saml2X509Credential.verification((X509Certificate)idpCert);
                registrationBuilder.assertingPartyDetails(party -> party.verificationX509Credentials(c -> {
                    c.clear();
                    c.add(verification);
                }));
            }
            RelyingPartyRegistration registration = registrationBuilder.build();
            this.relyingPartyRegistrationRepository = new InMemoryRelyingPartyRegistrationRepository(new RelyingPartyRegistration[]{registration});
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public RelyingPartyRegistration findByRegistrationId(String id) {
        if (this.relyingPartyRegistrationRepository == null) {
            this.init();
        }
        return this.relyingPartyRegistrationRepository != null ? this.relyingPartyRegistrationRepository.findByRegistrationId(id) : null;
    }

    @Override
    public Iterator<RelyingPartyRegistration> iterator() {
        if (this.relyingPartyRegistrationRepository == null) {
            this.init();
        }
        return this.relyingPartyRegistrationRepository != null ? this.relyingPartyRegistrationRepository.iterator() : null;
    }
}

