/*
 * Decompiled with CFR 0.152.
 */
package org.openl.security.saml;

import org.openl.security.saml.LazyInMemoryRelyingPartyRegistrationRepository;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.impl.AuthnRequestMarshaller;
import org.springframework.core.env.PropertyResolver;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.provider.service.authentication.OpenSaml4AuthenticationProvider;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.DefaultRelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.DefaultSaml2AuthenticationRequestContextResolver;
import org.springframework.security.saml2.provider.service.web.RelyingPartyRegistrationResolver;
import org.springframework.security.saml2.provider.service.web.Saml2AuthenticationRequestContextResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenLSamlBuilder {
    private static boolean forceAuthN;
    private LazyInMemoryRelyingPartyRegistrationRepository relyingPartyRegistrationRepository;

    public OpenLSamlBuilder(PropertyResolver propertyResolver) {
        forceAuthN = Boolean.parseBoolean(propertyResolver.getProperty("security.saml.forceAuthN"));
        this.relyingPartyRegistrationRepository = new LazyInMemoryRelyingPartyRegistrationRepository(propertyResolver);
    }

    public RelyingPartyRegistrationRepository relyingPartyRegistration() {
        return this.relyingPartyRegistrationRepository;
    }

    public Saml2AuthenticationRequestContextResolver authenticationRequestContextResolver() {
        return new DefaultSaml2AuthenticationRequestContextResolver(this.relyingPartyRegistrationResolver());
    }

    public RelyingPartyRegistrationResolver relyingPartyRegistrationResolver() {
        return new DefaultRelyingPartyRegistrationResolver((RelyingPartyRegistrationRepository)this.relyingPartyRegistrationRepository);
    }

    public OpenSaml4AuthenticationProvider openSaml4AuthenticationProvider() {
        return new OpenSaml4AuthenticationProvider();
    }

    static {
        OpenSamlInitializationService.requireInitialize(factory -> {
            AuthnRequestMarshaller marshaller = new AuthnRequestMarshaller(){

                public Element marshall(XMLObject object, Element element) throws MarshallingException {
                    this.configureAuthnRequest((AuthnRequest)object);
                    return super.marshall(object, element);
                }

                public Element marshall(XMLObject object, Document document) throws MarshallingException {
                    this.configureAuthnRequest((AuthnRequest)object);
                    return super.marshall(object, document);
                }

                private void configureAuthnRequest(AuthnRequest authnRequest) {
                    authnRequest.setForceAuthn(Boolean.valueOf(forceAuthN));
                }
            };
            factory.getMarshallerFactory().registerMarshaller(AuthnRequest.DEFAULT_ELEMENT_NAME, (Marshaller)marshaller);
        });
    }
}

