/*
 * Decompiled with CFR 0.152.
 */
package org.openl.security.saml;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2RelyingPartyInitiatedLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;

public class SamlLogoutSuccessHandler
extends SecurityContextLogoutHandler
implements LogoutHandler {
    private final Logger log = LoggerFactory.getLogger(SamlLogoutSuccessHandler.class);
    private final Saml2RelyingPartyInitiatedLogoutSuccessHandler logoutHandler;

    public SamlLogoutSuccessHandler(OpenSaml4LogoutRequestResolver requestResolver) {
        this.logoutHandler = new Saml2RelyingPartyInitiatedLogoutSuccessHandler((Saml2LogoutRequestResolver)requestResolver);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        super.logout(request, response, authentication);
        try {
            this.logoutHandler.onLogoutSuccess(request, response, authentication);
            response.getWriter().flush();
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
        }
    }
}

