/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.expressions;

import org.openlca.expressions.AbstractExpression;
import org.openlca.expressions.Expression;
import org.openlca.expressions.ExpressionException;

abstract class AbstractComparisonExpression
extends AbstractExpression {
    AbstractComparisonExpression() {
    }

    @Override
    public void check() throws ExpressionException {
        if (this.arguments.size() != 2) {
            throw new ExpressionException("Comparison operator should have exactly 2 arguments", this.getLine(), this.getColumn());
        }
        Expression functionA = (Expression)this.arguments.get(0);
        if (functionA.getResultType() != null && !Comparable.class.isAssignableFrom(functionA.getResultType())) {
            throw new ExpressionException("Invalid argument for comparison expression", this.getLine(), this.getColumn());
        }
        Expression functionB = (Expression)this.arguments.get(1);
        if (functionA.getResultType() != null && functionB.getResultType() != null && functionA.getResultType() != functionB.getResultType()) {
            throw new ExpressionException("Cannot compare things of different types", this.getLine(), this.getColumn());
        }
    }

    @Override
    public Class<?> getResultType() {
        return Boolean.class;
    }
}

