/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.expressions;

import org.openlca.expressions.AbstractExpression;
import org.openlca.expressions.Expression;
import org.openlca.expressions.ExpressionException;

public abstract class AbstractNumericOperator
extends AbstractExpression {
    @Override
    public void check() throws ExpressionException {
        if (this.arguments.size() != 2) {
            throw new ExpressionException("Numeric operator requires 2 arguments", this.getLine(), this.getColumn());
        }
        Expression expr1 = (Expression)this.arguments.get(0);
        if (expr1.getResultType() != null && !Double.class.isAssignableFrom(expr1.getResultType())) {
            throw new ExpressionException("Non-decimal argument for numeric operator", expr1.getLine(), expr1.getColumn());
        }
        Expression expr2 = (Expression)this.arguments.get(1);
        if (expr2.getResultType() != null && !Double.class.isAssignableFrom(expr2.getResultType())) {
            throw new ExpressionException("Non-decimal argument for numeric operator", expr2.getLine(), expr2.getColumn());
        }
    }

    @Override
    public Class<?> getResultType() {
        return Double.class;
    }
}

