/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.expressions;

import java.util.HashMap;
import org.openlca.expressions.InterpreterException;
import org.openlca.expressions.Scope;

public class FormulaInterpreter {
    private final Scope globalScope;
    private final HashMap<Long, Scope> scopes = new HashMap();

    public FormulaInterpreter() {
        this.globalScope = new Scope();
    }

    public void clear() {
        this.globalScope.clear();
        this.scopes.clear();
    }

    public double eval(String expression) throws InterpreterException {
        return this.globalScope.eval(expression);
    }

    public void bind(String variableName, String expression) {
        this.getGlobalScope().bind(variableName, expression);
    }

    public Scope getGlobalScope() {
        return this.globalScope;
    }

    public Scope createScope(long id) {
        return this.createScope(id, this.globalScope);
    }

    public Scope createScope(long id, Scope parent) {
        Scope scope = new Scope(parent);
        this.scopes.put(id, scope);
        return scope;
    }

    public boolean hasScope(long id) {
        return this.scopes.containsKey(id);
    }

    public Scope getScope(long id) {
        return this.scopes.get(id);
    }
}

