/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.expressions;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.openlca.expressions.FormulaInterpreter;

public class Repl {
    private BufferedReader in;
    private PrintStream out;
    private PrintStream err;
    FormulaInterpreter evaluator = new FormulaInterpreter();

    public Repl(InputStream in, PrintStream out, PrintStream err) {
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = out;
        this.err = err;
    }

    public void start() {
        this.printWelcome();
        String line = null;
        try {
            String expression;
            while ((line = this.in.readLine()) != null && !(expression = line.trim()).equalsIgnoreCase("exit") && !expression.equalsIgnoreCase("quit")) {
                this.eval(expression);
                this.out.print("olca<< ");
            }
        }
        catch (Exception e) {
            this.err.println("An unexpected error occurred: " + e.getMessage());
        }
        this.out.flush();
        this.err.flush();
    }

    private void eval(String expression) {
        if (expression.isEmpty()) {
            this.out.println("olca>> ");
        } else if (expression.equalsIgnoreCase("help")) {
            this.printHelp();
        } else if (expression.startsWith("var ")) {
            this.evalVariable(expression);
        } else {
            this.evalFormula(expression);
        }
    }

    private void printWelcome() {
        this.out.println("openLCA Formula Interpreter");
        this.out.println("type 'help' to display the help message");
        this.out.println("");
        this.out.print("olca<< ");
    }

    private void printHelp() {
        this.out.println(" evaluate an expression: \t type in the expression and press enter, e.g. sin(42)");
        this.out.println(" define a variable: \t\t type var <variable name> = <expression>, e.g. var a = sin(42)");
        this.out.println(" exit the interpreter: \t\t type 'exit' or 'quit' and press enter");
    }

    private void evalVariable(String expression) {
        StringBuffer variableNameBuf = new StringBuffer();
        StringBuffer formulaBuf = new StringBuffer();
        this.parseVariableExpression(expression.substring(4), variableNameBuf, formulaBuf);
        String variableName = variableNameBuf.toString().trim();
        String formula = formulaBuf.toString().trim();
        if (variableName.isEmpty() || formula.isEmpty()) {
            this.err.println("error>> Wrong variable declaration (syntax is 'var <identifier> = <expression>'). ");
        } else {
            this.evalVariable(variableName, formula);
        }
    }

    private void parseVariableExpression(String expression, StringBuffer variableNameBuf, StringBuffer formulaBuf) {
        boolean after = false;
        for (char c : expression.toCharArray()) {
            if (c != '=' && !after) {
                variableNameBuf.append(c);
                continue;
            }
            if (c == '=' && !after) {
                after = true;
                continue;
            }
            if (!after) continue;
            formulaBuf.append(c);
        }
    }

    private void evalVariable(String variableName, String formula) {
        try {
            this.evaluator.getGlobalScope().bind(variableName, formula);
            double val = this.evaluator.eval(variableName);
            this.out.println("olca>> " + variableName + " = " + val);
        }
        catch (Exception e) {
            this.err.println("error>> " + e.getMessage());
        }
    }

    private void evalFormula(String expression) {
        try {
            Double result = this.evaluator.eval(expression);
            this.out.println("olca>> " + result);
        }
        catch (Exception e) {
            this.err.println("error>> " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        Repl repl = new Repl(System.in, System.out, System.err);
        repl.start();
    }
}

