/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.expressions;

import java.io.StringReader;
import java.util.HashMap;
import org.openlca.expressions.Constants;
import org.openlca.expressions.Expression;
import org.openlca.expressions.FormulaParser;
import org.openlca.expressions.InterpreterException;

public final class Scope {
    private final Scope parent;
    private final HashMap<String, Integer> evaluationCalls = new HashMap();
    private final HashMap<String, Variable> variables = new HashMap();

    Scope() {
        this(null);
    }

    Scope(Scope parent) {
        this.parent = parent;
    }

    public void bind(String variableName, String expression) {
        if (variableName == null || expression == null) {
            return;
        }
        String symbol = variableName.toLowerCase().trim();
        Variable var = new Variable();
        var.name = symbol;
        var.expression = expression;
        this.variables.put(symbol, var);
    }

    public void clear() {
        this.variables.clear();
        this.evaluationCalls.clear();
    }

    public double eval(String expression) throws InterpreterException {
        for (String var : this.evaluationCalls.keySet()) {
            this.evaluationCalls.put(var, 0);
        }
        for (Variable variable : this.variables.values()) {
            variable.value = null;
        }
        try {
            return this.tryEval(expression);
        }
        catch (Throwable e) {
            throw new InterpreterException("Evaluation of expression " + expression + " failed: " + e.getMessage(), e);
        }
    }

    private double tryEval(String expression) throws Exception {
        StringReader reader = new StringReader(expression.toLowerCase());
        FormulaParser parser = new FormulaParser(reader);
        parser.parse();
        Expression e = parser.getExpression();
        e.check();
        Object result = e.evaluate(this);
        if (!(result instanceof Double)) {
            throw new InterpreterException("The given expression " + expression + " does not evaluate to a number.");
        }
        return (Double)result;
    }

    public Object resolveVariable(String name) throws InterpreterException {
        Variable var = this.variables.get(name);
        if (var != null) {
            if (var.isEvaluated()) {
                return var.value;
            }
            return this.eval(var);
        }
        if (this.parent == null) {
            return Constants.get(name);
        }
        return this.parent.resolveVariable(name);
    }

    private Object eval(Variable var) throws InterpreterException {
        Integer call = this.evaluationCalls.get(var.name);
        if (call != null && call > 0) {
            throw new InterpreterException("Second evaluation call on variable " + var.name + ". Cyclic dependencies?");
        }
        this.evaluationCalls.put(var.name, 1);
        try {
            var.value = this.tryEval(var.expression);
            return var.value;
        }
        catch (Throwable e) {
            throw new InterpreterException("Evaluation of variable " + var.name + " failed: " + e.getMessage(), e);
        }
    }

    private class Variable {
        private String name;
        private String expression;
        private Double value;

        private Variable() {
        }

        public boolean isEvaluated() {
            return this.value != null;
        }
    }
}

