/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv;

import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.openlca.simapro.csv.CsvHeader;
import org.openlca.simapro.csv.CsvRecord;
import org.openlca.simapro.csv.Numeric;
import org.openlca.simapro.csv.SimaProCsv;

public class CsvBuffer {
    private final CSVPrinter printer;
    private final char decimalSeparator;
    private final SimpleDateFormat dateFormat;
    private final List<String> buffer = new ArrayList<String>();

    public CsvBuffer(Writer writer, CsvHeader header) {
        this.decimalSeparator = header.decimalSeparator();
        this.dateFormat = header.shortDateFormat();
        CSVFormat format = SimaProCsv.formatOf(header.csvSeparator());
        try {
            this.printer = new CSVPrinter((Appendable)writer, format);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create CSVPrinter", e);
        }
    }

    public CsvBuffer writeln() {
        try {
            this.printer.printRecord(this.buffer);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to print record", e);
        }
        this.buffer.clear();
        return this;
    }

    public CsvBuffer putString(String s) {
        if (s == null) {
            this.buffer.add("");
            return this;
        }
        this.buffer.add(s.replaceAll("\\r?\\n", Character.toString('\u007f')));
        return this;
    }

    public CsvBuffer putDouble(double d) {
        if (d == (double)((int)d)) {
            return this.putString(Integer.toString((int)d));
        }
        String s = Double.toString(d);
        return this.putString(this.decimalPoint(s));
    }

    public CsvBuffer putInt(int i) {
        String s = Integer.toString(i);
        return this.putString(s);
    }

    public CsvBuffer putNumeric(Numeric n) {
        if (n == null) {
            this.putDouble(0.0);
        } else if (n.hasFormula()) {
            this.putString(this.decimalPoint(n.formula()));
        } else {
            this.putDouble(n.value());
        }
        return this;
    }

    public CsvBuffer putBoolean(boolean b) {
        return this.putString(b ? "Yes" : "No");
    }

    public CsvBuffer putDate(Date date) {
        if (date == null) {
            return this.putString("");
        }
        try {
            String s = this.dateFormat.format(date);
            return this.putString(s);
        }
        catch (Exception e) {
            return this.putString("");
        }
    }

    public CsvBuffer putRecord(CsvRecord record) {
        if (record != null) {
            record.write(this);
        }
        return this;
    }

    public CsvBuffer putRecords(Iterable<? extends CsvRecord> records) {
        for (CsvRecord csvRecord : records) {
            this.putRecord(csvRecord);
        }
        return this;
    }

    private String decimalPoint(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (this.decimalSeparator == '.') {
            return s;
        }
        return s.replace('.', this.decimalSeparator);
    }
}

