/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvHeader;
import org.openlca.simapro.csv.CsvRecord;
import org.openlca.simapro.csv.SimaProCsv;
import org.openlca.simapro.csv.enums.ElementaryFlowType;
import org.openlca.simapro.csv.method.ImpactMethodBlock;
import org.openlca.simapro.csv.process.ProcessBlock;
import org.openlca.simapro.csv.process.ProductStageBlock;
import org.openlca.simapro.csv.refdata.CalculatedParameterRow;
import org.openlca.simapro.csv.refdata.ElementaryFlowRow;
import org.openlca.simapro.csv.refdata.InputParameterRow;
import org.openlca.simapro.csv.refdata.LiteratureReferenceBlock;
import org.openlca.simapro.csv.refdata.QuantityRow;
import org.openlca.simapro.csv.refdata.SystemDescriptionBlock;
import org.openlca.simapro.csv.refdata.UnitRow;

public class CsvDataSet {
    private final CsvHeader header;
    private final List<ProductStageBlock> productStages = new ArrayList<ProductStageBlock>();
    private final List<ProcessBlock> processes = new ArrayList<ProcessBlock>();
    private final List<SystemDescriptionBlock> systemDescriptions = new ArrayList<SystemDescriptionBlock>();
    private final List<ImpactMethodBlock> methods = new ArrayList<ImpactMethodBlock>();
    private final List<QuantityRow> quantities = new ArrayList<QuantityRow>();
    private final List<UnitRow> units = new ArrayList<UnitRow>();
    private final List<ElementaryFlowRow> rawMaterials = new ArrayList<ElementaryFlowRow>();
    private final List<ElementaryFlowRow> airborneEmissions = new ArrayList<ElementaryFlowRow>();
    private final List<ElementaryFlowRow> waterborneEmissions = new ArrayList<ElementaryFlowRow>();
    private final List<ElementaryFlowRow> finalWasteFlows = new ArrayList<ElementaryFlowRow>();
    private final List<ElementaryFlowRow> emissionsToSoil = new ArrayList<ElementaryFlowRow>();
    private final List<ElementaryFlowRow> nonMaterialEmissions = new ArrayList<ElementaryFlowRow>();
    private final List<ElementaryFlowRow> socialIssues = new ArrayList<ElementaryFlowRow>();
    private final List<ElementaryFlowRow> economicIssues = new ArrayList<ElementaryFlowRow>();
    private final List<InputParameterRow> databaseInputParameters = new ArrayList<InputParameterRow>();
    private final List<CalculatedParameterRow> databaseCalculatedParameters = new ArrayList<CalculatedParameterRow>();
    private final List<InputParameterRow> projectInputParameters = new ArrayList<InputParameterRow>();
    private final List<CalculatedParameterRow> projectCalculatedParameters = new ArrayList<CalculatedParameterRow>();
    private final List<LiteratureReferenceBlock> literatureReferences = new ArrayList<LiteratureReferenceBlock>();

    public CsvDataSet() {
        this(new CsvHeader());
    }

    public CsvDataSet(CsvHeader header) {
        this.header = header;
    }

    public CsvHeader header() {
        return this.header;
    }

    public List<ProductStageBlock> productStages() {
        return this.productStages;
    }

    public List<ProcessBlock> processes() {
        return this.processes;
    }

    public List<SystemDescriptionBlock> systemDescriptions() {
        return this.systemDescriptions;
    }

    public List<ImpactMethodBlock> methods() {
        return this.methods;
    }

    public List<QuantityRow> quantities() {
        return this.quantities;
    }

    public List<UnitRow> units() {
        return this.units;
    }

    public List<ElementaryFlowRow> rawMaterials() {
        return this.rawMaterials;
    }

    public List<ElementaryFlowRow> airborneEmissions() {
        return this.airborneEmissions;
    }

    public List<ElementaryFlowRow> waterborneEmissions() {
        return this.waterborneEmissions;
    }

    public List<ElementaryFlowRow> finalWasteFlows() {
        return this.finalWasteFlows;
    }

    public List<ElementaryFlowRow> emissionsToSoil() {
        return this.emissionsToSoil;
    }

    public List<ElementaryFlowRow> nonMaterialEmissions() {
        return this.nonMaterialEmissions;
    }

    public List<ElementaryFlowRow> socialIssues() {
        return this.socialIssues;
    }

    public List<ElementaryFlowRow> economicIssues() {
        return this.economicIssues;
    }

    public List<InputParameterRow> databaseInputParameters() {
        return this.databaseInputParameters;
    }

    public List<CalculatedParameterRow> databaseCalculatedParameters() {
        return this.databaseCalculatedParameters;
    }

    public List<InputParameterRow> projectInputParameters() {
        return this.projectInputParameters;
    }

    public List<CalculatedParameterRow> projectCalculatedParameters() {
        return this.projectCalculatedParameters;
    }

    public List<LiteratureReferenceBlock> literatureReferences() {
        return this.literatureReferences;
    }

    public List<ElementaryFlowRow> getElementaryFlows(ElementaryFlowType type) {
        if (type == null) {
            return new ArrayList<ElementaryFlowRow>();
        }
        switch (type) {
            case RESOURCES: {
                return this.rawMaterials;
            }
            case EMISSIONS_TO_AIR: {
                return this.airborneEmissions;
            }
            case EMISSIONS_TO_WATER: {
                return this.waterborneEmissions;
            }
            case EMISSIONS_TO_SOIL: {
                return this.emissionsToSoil;
            }
            case FINAL_WASTE_FLOWS: {
                return this.finalWasteFlows;
            }
            case NON_MATERIAL_EMISSIONS: {
                return this.nonMaterialEmissions;
            }
            case SOCIAL_ISSUES: {
                return this.socialIssues;
            }
            case ECONOMIC_ISSUES: {
                return this.economicIssues;
            }
        }
        return new ArrayList<ElementaryFlowRow>();
    }

    public void write(File file) {
        try (FileWriter writer = new FileWriter(file, SimaProCsv.defaultCharset());){
            this.write(new CsvBuffer(writer, this.header));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to write file: " + file, e);
        }
    }

    public void write(CsvBuffer buffer) throws IOException {
        this.header.write(buffer);
        for (ProductStageBlock stage : this.productStages) {
            stage.write(buffer);
        }
        for (ProcessBlock process : this.processes) {
            process.write(buffer);
        }
        for (SystemDescriptionBlock description : this.systemDescriptions) {
            description.write(buffer);
        }
        for (ImpactMethodBlock method : this.methods) {
            method.write(buffer);
        }
        this.writeRows(buffer, "Quantities", this.quantities);
        this.writeRows(buffer, "Units", this.units);
        this.writeRows(buffer, "Raw materials", this.rawMaterials);
        this.writeRows(buffer, "Airborne emissions", this.airborneEmissions);
        this.writeRows(buffer, "Waterborne emissions", this.waterborneEmissions);
        this.writeRows(buffer, "Final waste flows", this.finalWasteFlows);
        this.writeRows(buffer, "Emissions to soil", this.emissionsToSoil);
        this.writeRows(buffer, "Non material emissions", this.nonMaterialEmissions);
        this.writeRows(buffer, "Social issues", this.socialIssues);
        this.writeRows(buffer, "Economic issues", this.economicIssues);
        this.writeRows(buffer, "Database Input parameters", this.databaseInputParameters);
        this.writeRows(buffer, "Database Calculated parameters", this.databaseCalculatedParameters);
        this.writeRows(buffer, "Project Input parameters", this.projectInputParameters);
        this.writeRows(buffer, "Project Calculated parameters", this.projectCalculatedParameters);
        this.writeRows(buffer, "Literature reference", this.literatureReferences);
    }

    private void writeRows(CsvBuffer buffer, String header, List<? extends CsvRecord> rows) {
        if (rows.isEmpty()) {
            return;
        }
        buffer.putString(header).writeln();
        for (CsvRecord csvRecord : rows) {
            csvRecord.write(buffer);
        }
        buffer.writeln().putString("End").writeln().writeln();
    }
}

