/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.SimaProCsv;

public class CsvHeader {
    private String version;
    private String date;
    private String time;
    private String project;
    private String formatVersion;
    private SimpleDateFormat shortDateFormat;
    private char csvSeparator = (char)59;
    private char decimalSeparator = (char)46;
    private char dateSeparator = (char)46;

    public String version() {
        return this.version;
    }

    public CsvHeader version(String version) {
        this.version = version;
        return this;
    }

    public String date() {
        return this.date;
    }

    public CsvHeader date(String date) {
        this.date = date;
        return this;
    }

    public String time() {
        return this.time;
    }

    public CsvHeader time(String time) {
        this.time = time;
        return this;
    }

    public String project() {
        return this.project;
    }

    public CsvHeader project(String project) {
        this.project = project;
        return this;
    }

    public String formatVersion() {
        return this.formatVersion;
    }

    public CsvHeader formatVersion(String formatVersion) {
        this.formatVersion = formatVersion;
        return this;
    }

    public char csvSeparator() {
        return this.csvSeparator;
    }

    public CsvHeader csvSeparator(char csvSeparator) {
        this.csvSeparator = csvSeparator;
        return this;
    }

    public char decimalSeparator() {
        return this.decimalSeparator;
    }

    public CsvHeader decimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
        return this;
    }

    public char dateSeparator() {
        return this.dateSeparator;
    }

    public CsvHeader dateSeparator(char dateSeparator) {
        this.dateSeparator = dateSeparator;
        return this;
    }

    public SimpleDateFormat shortDateFormat() {
        if (this.shortDateFormat == null) {
            this.shortDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        }
        return this.shortDateFormat;
    }

    public CsvHeader shortDateFormat(SimpleDateFormat shortDateFormat) {
        this.shortDateFormat = shortDateFormat;
        return this;
    }

    public static CsvHeader readFrom(File file) {
        CsvHeader csvHeader;
        block8: {
            Reader reader = SimaProCsv.readerOf(file);
            try {
                csvHeader = CsvHeader.readFrom(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("failed to read header from " + file, e);
                }
            }
            reader.close();
        }
        return csvHeader;
    }

    public static CsvHeader readFrom(Reader reader) {
        CsvHeader header = new CsvHeader();
        if (reader == null) {
            return header;
        }
        try {
            CSVRecord record;
            String s;
            CSVParser parser = CSVParser.parse((Reader)reader, (CSVFormat)SimaProCsv.formatOf(';'));
            Iterator iterator = parser.iterator();
            while (iterator.hasNext() && !(s = CsvHeader.unbraced((record = (CSVRecord)iterator.next()).get(0))).isEmpty()) {
                Optional<String> version = CsvHeader.match(s, "SimaPro ");
                if (version.isPresent()) {
                    header.version(version.get());
                    continue;
                }
                Optional<String> date = CsvHeader.match(s, "Date: ");
                if (date.isPresent()) {
                    header.date(date.get());
                    continue;
                }
                Optional<String> time = CsvHeader.match(s, "Time: ");
                if (time.isPresent()) {
                    header.time(time.get());
                    continue;
                }
                Optional<String> project = CsvHeader.match(s, "Project: ");
                if (project.isPresent()) {
                    header.project(project.get());
                    continue;
                }
                Optional<String> formatVersion = CsvHeader.match(s, "CSV Format version: ");
                if (formatVersion.isPresent()) {
                    header.formatVersion(formatVersion.get());
                    continue;
                }
                Optional<String> csvSeparator = CsvHeader.match(s, "CSV separator: ");
                if (csvSeparator.isPresent()) {
                    String del = csvSeparator.get().toLowerCase();
                    header.csvSeparator(del.equals("comma") ? (char)',' : ';');
                    continue;
                }
                Optional<String> decimalSeparator = CsvHeader.match(s, "Decimal separator: ");
                if (decimalSeparator.isPresent()) {
                    String sep = decimalSeparator.get();
                    header.decimalSeparator(sep.length() == 0 ? (char)'.' : sep.charAt(0));
                    continue;
                }
                Optional<String> dateSeparator = CsvHeader.match(s, "Date separator: ");
                if (dateSeparator.isPresent()) {
                    String sep = dateSeparator.get();
                    header.dateSeparator(sep.length() == 0 ? (char)'-' : sep.charAt(0));
                    continue;
                }
                Optional<String> dateFormat = CsvHeader.match(s, "Short date format: ");
                if (!dateFormat.isPresent()) continue;
                try {
                    header.shortDateFormat = new SimpleDateFormat(dateFormat.get());
                }
                catch (Exception exception) {}
            }
            return header;
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read CSV", e);
        }
    }

    private static String unbraced(String s) {
        int len = s.length();
        if (len == 0) {
            return s;
        }
        int start = s.charAt(0) == '{' ? 1 : 0;
        int end = s.charAt(len - 1) == '}' ? len - 1 : len;
        return start == 1 || end < len ? s.substring(start, end) : s;
    }

    private static Optional<String> match(String s, String prefix) {
        if (!s.startsWith(prefix)) {
            return Optional.empty();
        }
        String m = s.substring(prefix.length());
        return Optional.of(m.trim());
    }

    public void write(CsvBuffer buffer) {
        String v = this.version != null ? this.version : "9.1.0.0";
        buffer.putString("{SimaPro " + v + "}").writeln();
        String dateStr = this.date == null ? this.shortDateFormat().format(new Date()) : this.date;
        buffer.putString("{Date: " + dateStr + "}").writeln();
        String timeStr = this.time == null ? new SimpleDateFormat("hh:mm:ss").format(new Date()) : this.time;
        buffer.putString("{Time: " + timeStr + "}").writeln();
        if (this.project != null) {
            buffer.putString("{Project: " + this.project + "}").writeln();
        }
        String f = this.formatVersion != null ? this.formatVersion : "9.0.0";
        buffer.putString("{CSV Format version: " + this.formatVersion + "}").writeln();
        String csvSep = this.csvSeparator == ';' ? "Semicolon" : "Comma";
        buffer.putString("{CSV separator: " + csvSep + "}").writeln();
        buffer.putString("{Decimal separator: " + this.decimalSeparator + "}").writeln();
        buffer.putString("{Date separator: " + this.dateSeparator + "}").writeln();
        buffer.putString("{Short date format: " + this.shortDateFormat().toPattern() + "}").writeln();
        buffer.writeln();
    }
}

