/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv;

import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.csv.CSVRecord;
import org.openlca.simapro.csv.CsvHeader;
import org.openlca.simapro.csv.CsvScanner;
import org.openlca.simapro.csv.Numeric;

public final class CsvLine {
    private final CSVRecord csv;
    private final char decimalSeparator;
    private final SimpleDateFormat dateFormat;

    private CsvLine(CSVRecord csv, CsvHeader header) {
        this.csv = Objects.requireNonNull(csv);
        this.decimalSeparator = header.decimalSeparator();
        this.dateFormat = header.shortDateFormat();
    }

    static CsvLine of(CSVRecord csv, CsvHeader header) {
        return new CsvLine(csv, header);
    }

    public static Iterable<CsvLine> iter(CsvHeader header, Reader reader) {
        return new CsvScanner(header, reader);
    }

    public static Optional<CsvLine> nextOf(Iterator<CsvLine> it) {
        return it == null || !it.hasNext() ? Optional.empty() : Optional.ofNullable(it.next());
    }

    public static void moveTo(Iterator<CsvLine> it, String section) {
        CsvLine next;
        while (it.hasNext() && !(next = it.next()).first().equals(section)) {
        }
    }

    public static String nextString(Iterator<CsvLine> it) {
        return CsvLine.nextOf(it).map(CsvLine::first).orElse("");
    }

    public static boolean nextBool(Iterator<CsvLine> it) {
        return CsvLine.nextOf(it).map(line -> line.getBoolean(0)).orElse(false);
    }

    public static void untilEmpty(Iterator<CsvLine> it, Consumer<CsvLine> fn) {
        CsvLine line;
        if (it == null || fn == null) {
            return;
        }
        while (it.hasNext() && !(line = it.next()).isEmpty() && !line.first().equals("End")) {
            fn.accept(line);
        }
    }

    public int size() {
        return this.csv.size();
    }

    public String getString(int pos) {
        if (pos < 0 || pos >= this.csv.size()) {
            return "";
        }
        return this.csv.get(pos).replace('\u007f', '\n');
    }

    public double getDouble(int pos) {
        String str = this.getString(pos);
        return str.length() == 0 ? 0.0 : Double.parseDouble(this.decimalPoint(str));
    }

    public int getInt(int pos) {
        String str = this.getString(pos);
        return str.length() == 0 ? 0 : Integer.parseInt(str);
    }

    public Numeric getNumeric(int pos) {
        String raw = this.getString(pos);
        String cleaned = this.decimalPoint(raw);
        if (cleaned.length() == 0) {
            return Numeric.of(0.0);
        }
        try {
            double number = Double.parseDouble(cleaned);
            return Numeric.of(number);
        }
        catch (NumberFormatException e) {
            return Numeric.of(raw);
        }
    }

    public Date getDate(int pos) {
        String s = this.getString(pos);
        if (s.isEmpty()) {
            return null;
        }
        try {
            return this.dateFormat.parse(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFormula(int pos) {
        return this.decimalPoint(this.getString(pos));
    }

    public boolean getBoolean(int pos) {
        String s = this.getString(pos);
        return s.equalsIgnoreCase("yes");
    }

    private String decimalPoint(String s) {
        if (this.decimalSeparator == '.') {
            return s;
        }
        if (s.length() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '.') continue;
            if (c == this.decimalSeparator) {
                buffer.append('.');
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.csv.size(); ++i) {
            String s = this.csv.get(i);
            if (s.length() <= 0) continue;
            return false;
        }
        return true;
    }

    public String first() {
        return this.getString(0);
    }
}

