/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv;

import java.util.Objects;
import org.openlca.simapro.csv.CsvHeader;

public class FormulaConverter {
    private final CsvHeader header;
    private char decimalSeparator;
    private char parameterSeparator;

    private FormulaConverter(CsvHeader header) {
        this.header = Objects.requireNonNull(header);
        this.decimalSeparator = header.decimalSeparator();
        this.parameterSeparator = (char)(this.decimalSeparator == ',' ? 59 : 44);
    }

    public static FormulaConverter of(CsvHeader header) {
        return new FormulaConverter(header);
    }

    public FormulaConverter decimalSeparator(char c) {
        this.decimalSeparator = c;
        return this;
    }

    public FormulaConverter parameterSeparator(char parameterSeparator) {
        this.parameterSeparator = parameterSeparator;
        return this;
    }

    public String convert(String formula) {
        if (formula == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < formula.length(); ++i) {
            char c = formula.charAt(i);
            if (c == this.header.decimalSeparator()) {
                buffer.append(this.decimalSeparator);
                continue;
            }
            if (c == ',' || c == ';') {
                buffer.append(this.parameterSeparator);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

