/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv;

public class Numeric {
    private final double value;
    private final String formula;
    private static final Numeric zero = new Numeric(0.0, null);

    private Numeric(double value, String formula) {
        this.value = value;
        this.formula = formula;
    }

    public static Numeric of(double value) {
        return new Numeric(value, null);
    }

    public static Numeric of(String formula) {
        if (formula == null || formula.isBlank()) {
            return zero;
        }
        return new Numeric(0.0, formula);
    }

    public static Numeric zero() {
        return zero;
    }

    public boolean hasFormula() {
        return this.formula != null;
    }

    public String formula() {
        return this.formula;
    }

    public double value() {
        return this.value;
    }

    public String toString() {
        return this.hasFormula() ? this.formula : Double.toString(this.value);
    }
}

