/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.commons.csv.CSVFormat;
import org.openlca.simapro.csv.CsvBlock;
import org.openlca.simapro.csv.CsvDataSet;
import org.openlca.simapro.csv.CsvHeader;
import org.openlca.simapro.csv.CsvLine;
import org.openlca.simapro.csv.enums.ElementaryFlowType;
import org.openlca.simapro.csv.method.ImpactMethodBlock;
import org.openlca.simapro.csv.process.ProcessBlock;
import org.openlca.simapro.csv.process.ProductStageBlock;
import org.openlca.simapro.csv.refdata.CalculatedParameterBlock;
import org.openlca.simapro.csv.refdata.CalculatedParameterRow;
import org.openlca.simapro.csv.refdata.ElementaryFlowBlock;
import org.openlca.simapro.csv.refdata.ElementaryFlowRow;
import org.openlca.simapro.csv.refdata.InputParameterBlock;
import org.openlca.simapro.csv.refdata.InputParameterRow;
import org.openlca.simapro.csv.refdata.LiteratureReferenceBlock;
import org.openlca.simapro.csv.refdata.QuantityBlock;
import org.openlca.simapro.csv.refdata.QuantityRow;
import org.openlca.simapro.csv.refdata.SystemDescriptionBlock;
import org.openlca.simapro.csv.refdata.UnitBlock;
import org.openlca.simapro.csv.refdata.UnitRow;

public final class SimaProCsv {
    private SimaProCsv() {
    }

    public static Charset defaultCharset() {
        return Charset.forName("windows-1252");
    }

    static CSVFormat formatOf(char delimiter) {
        return CSVFormat.Builder.create().setDelimiter(delimiter).setTrim(true).setIgnoreEmptyLines(false).setQuote('\"').setIgnoreSurroundingSpaces(true).build();
    }

    public static Reader readerOf(File file) {
        return SimaProCsv.readerOf(file, SimaProCsv.defaultCharset());
    }

    public static Reader readerOf(File file, Charset charset) {
        if (file == null) {
            return null;
        }
        try {
            FileInputStream stream = new FileInputStream(file);
            return SimaProCsv.readerOf(stream, charset);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read file: " + file, e);
        }
    }

    public static Reader readerOf(InputStream stream, Charset charset) {
        if (stream == null) {
            return null;
        }
        Charset cs = charset == null ? SimaProCsv.defaultCharset() : charset;
        return new InputStreamReader(stream, cs);
    }

    public static void read(File file, Consumer<CsvBlock> fn) {
        CsvHeader header = CsvHeader.readFrom(file);
        try (Reader reader = SimaProCsv.readerOf(file);){
            Iterable<CsvLine> iter = CsvLine.iter(header, reader);
            for (CsvLine line : iter) {
                CsvBlock block;
                if (line.first().equals("Project Calculated parameters")) {
                    block = CalculatedParameterBlock.readProjectParameters(iter);
                    fn.accept(block);
                    continue;
                }
                if (line.first().equals("Database Calculated parameters")) {
                    block = CalculatedParameterBlock.readDatabaseParameters(iter);
                    fn.accept(block);
                    continue;
                }
                if (line.first().equals("Method")) {
                    block = ImpactMethodBlock.read(iter);
                    fn.accept(block);
                    continue;
                }
                if (line.first().equals("Project Input parameters")) {
                    block = InputParameterBlock.readProjectParameters(iter);
                    fn.accept(block);
                    continue;
                }
                if (line.first().equals("Database Input parameters")) {
                    block = InputParameterBlock.readDatabaseParameters(iter);
                    fn.accept(block);
                    continue;
                }
                if (line.first().equals("Process")) {
                    block = ProcessBlock.read(iter);
                    fn.accept(block);
                    continue;
                }
                if (line.first().equals("Product stage")) {
                    block = ProductStageBlock.read(iter);
                    fn.accept(block);
                    continue;
                }
                if (line.first().equals("Quantities")) {
                    block = QuantityBlock.read(iter);
                    fn.accept(block);
                    continue;
                }
                if (line.first().equals("System description")) {
                    block = SystemDescriptionBlock.read(iter);
                    fn.accept(block);
                    continue;
                }
                if (line.first().equals("Units")) {
                    block = UnitBlock.read(iter);
                    fn.accept(block);
                    continue;
                }
                ElementaryFlowType type = ElementaryFlowType.of(line.first());
                if (type == null) continue;
                ElementaryFlowBlock block2 = ElementaryFlowBlock.read(type, iter);
                fn.accept(block2);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read blocks from file: " + file, e);
        }
    }

    public static CsvDataSet read(File file) {
        CsvDataSet csvDataSet;
        block8: {
            CsvHeader header = CsvHeader.readFrom(file);
            Reader reader = SimaProCsv.readerOf(file);
            try {
                csvDataSet = SimaProCsv.read(header, reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("failed to read file: " + file, e);
                }
            }
            reader.close();
        }
        return csvDataSet;
    }

    public static CsvDataSet read(CsvHeader header, Reader reader) {
        CsvDataSet dataSet = new CsvDataSet(header);
        Iterable<CsvLine> iter = CsvLine.iter(header, reader);
        Iterator<CsvLine> lines = iter.iterator();
        while (lines.hasNext()) {
            CsvBlock block;
            CsvLine line = lines.next();
            if (line.first().equals("Product stage")) {
                block = ProductStageBlock.read(iter);
                dataSet.productStages().add((ProductStageBlock)block);
                continue;
            }
            if (line.first().equals("Process")) {
                block = ProcessBlock.read(iter);
                dataSet.processes().add((ProcessBlock)block);
                continue;
            }
            if (line.first().equals("System description")) {
                block = SystemDescriptionBlock.read(iter);
                dataSet.systemDescriptions().add((SystemDescriptionBlock)block);
                continue;
            }
            if (line.first().equals("Method")) {
                block = ImpactMethodBlock.read(iter);
                dataSet.methods().add((ImpactMethodBlock)block);
                continue;
            }
            if (line.first().equals("Quantities")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    QuantityRow row = QuantityRow.read(nextLine);
                    dataSet.quantities().add(row);
                });
                continue;
            }
            if (line.first().equals("Units")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    UnitRow row = UnitRow.read(nextLine);
                    dataSet.units().add(row);
                });
                continue;
            }
            if (line.first().equals("Raw materials")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    ElementaryFlowRow row = ElementaryFlowRow.read(nextLine);
                    dataSet.rawMaterials().add(row);
                });
                continue;
            }
            if (line.first().equals("Airborne emissions")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    ElementaryFlowRow row = ElementaryFlowRow.read(nextLine);
                    dataSet.airborneEmissions().add(row);
                });
                continue;
            }
            if (line.first().equals("Waterborne emissions")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    ElementaryFlowRow row = ElementaryFlowRow.read(nextLine);
                    dataSet.waterborneEmissions().add(row);
                });
                continue;
            }
            if (line.first().equals("Final waste flows")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    ElementaryFlowRow row = ElementaryFlowRow.read(nextLine);
                    dataSet.finalWasteFlows().add(row);
                });
                continue;
            }
            if (line.first().equals("Emissions to soil")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    ElementaryFlowRow row = ElementaryFlowRow.read(nextLine);
                    dataSet.emissionsToSoil().add(row);
                });
                continue;
            }
            if (line.first().equals("Non material emissions")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    ElementaryFlowRow row = ElementaryFlowRow.read(nextLine);
                    dataSet.nonMaterialEmissions().add(row);
                });
                continue;
            }
            if (line.first().equals("Social issues")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    ElementaryFlowRow row = ElementaryFlowRow.read(nextLine);
                    dataSet.socialIssues().add(row);
                });
                continue;
            }
            if (line.first().equals("Economic issues")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    ElementaryFlowRow row = ElementaryFlowRow.read(nextLine);
                    dataSet.economicIssues().add(row);
                });
                continue;
            }
            if (line.first().equals("Database Input parameters")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    InputParameterRow row = InputParameterRow.read(nextLine);
                    dataSet.databaseInputParameters().add(row);
                });
                continue;
            }
            if (line.first().equals("Database Calculated parameters")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    CalculatedParameterRow row = CalculatedParameterRow.read(nextLine);
                    dataSet.databaseCalculatedParameters().add(row);
                });
                continue;
            }
            if (line.first().equals("Project Input parameters")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    InputParameterRow row = InputParameterRow.read(nextLine);
                    dataSet.projectInputParameters().add(row);
                });
                continue;
            }
            if (line.first().equals("Project Calculated parameters")) {
                CsvLine.untilEmpty(lines, nextLine -> {
                    CalculatedParameterRow row = CalculatedParameterRow.read(nextLine);
                    dataSet.projectCalculatedParameters().add(row);
                });
                continue;
            }
            if (!line.first().equals("Literature reference")) continue;
            block = LiteratureReferenceBlock.read(iter);
            dataSet.literatureReferences().add((LiteratureReferenceBlock)block);
        }
        return dataSet;
    }
}

