/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.enums;

public enum ElementaryFlowType {
    RESOURCES("Resources", "Raw materials", "Raw"),
    EMISSIONS_TO_AIR("Emissions to air", "Airborne emissions", "Air"),
    EMISSIONS_TO_WATER("Emissions to water", "Waterborne emissions", "Water"),
    EMISSIONS_TO_SOIL("Emissions to soil", "Emissions to soil", "Soil"),
    FINAL_WASTE_FLOWS("Final waste flows", "Final waste flows", "Waste"),
    NON_MATERIAL_EMISSIONS("Non material emissions", "Non material emissions", "Non mat."),
    SOCIAL_ISSUES("Social issues", "Social issues", "Social"),
    ECONOMIC_ISSUES("Economic issues", "Economic issues", "Economic");

    private final String exchangeHeader;
    private final String blockHeader;
    private final String compartment;

    private ElementaryFlowType(String exchangeHeader, String blockHeader, String compartment) {
        this.exchangeHeader = exchangeHeader;
        this.blockHeader = blockHeader;
        this.compartment = compartment;
    }

    public String exchangeHeader() {
        return this.exchangeHeader;
    }

    public String blockHeader() {
        return this.blockHeader;
    }

    public String compartment() {
        return this.compartment;
    }

    public static ElementaryFlowType of(String value) {
        if (value == null) {
            return null;
        }
        String s = value.trim();
        for (ElementaryFlowType t : ElementaryFlowType.values()) {
            if (!s.equalsIgnoreCase(t.exchangeHeader) && !s.equalsIgnoreCase(t.blockHeader) && !s.equalsIgnoreCase(t.compartment)) continue;
            return t;
        }
        return null;
    }
}

