/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.method;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openlca.simapro.csv.CsvBlock;
import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvLine;
import org.openlca.simapro.csv.method.DamageCategoryBlock;
import org.openlca.simapro.csv.method.DamageCategoryRow;
import org.openlca.simapro.csv.method.DamageFactorRow;
import org.openlca.simapro.csv.method.ImpactCategoryBlock;
import org.openlca.simapro.csv.method.ImpactCategoryRow;
import org.openlca.simapro.csv.method.ImpactFactorRow;
import org.openlca.simapro.csv.method.NwSetBlock;
import org.openlca.simapro.csv.method.NwSetFactorRow;
import org.openlca.simapro.csv.method.VersionRow;

public class ImpactMethodBlock
implements CsvBlock {
    private String name;
    private VersionRow version;
    private String comment;
    private String category;
    private boolean useDamageAssessment;
    private boolean useNormalization;
    private boolean useWeighting;
    private boolean useAddition;
    private String weightingUnit;
    private final List<ImpactCategoryBlock> impactCategories = new ArrayList<ImpactCategoryBlock>();
    private final List<DamageCategoryBlock> damageCategories = new ArrayList<DamageCategoryBlock>();
    private final List<NwSetBlock> nwSets = new ArrayList<NwSetBlock>();

    public String name() {
        return this.name;
    }

    public ImpactMethodBlock name(String name) {
        this.name = name;
        return this;
    }

    public VersionRow version() {
        if (this.version == null) {
            this.version = new VersionRow();
        }
        return this.version;
    }

    public ImpactMethodBlock version(VersionRow version) {
        this.version = version;
        return this;
    }

    public String comment() {
        return this.comment;
    }

    public ImpactMethodBlock comment(String comment) {
        this.comment = comment;
        return this;
    }

    public String category() {
        return this.category;
    }

    public ImpactMethodBlock category(String category) {
        this.category = category;
        return this;
    }

    public boolean useDamageAssessment() {
        return this.useDamageAssessment;
    }

    public ImpactMethodBlock useDamageAssessment(boolean useDamageAssessment) {
        this.useDamageAssessment = useDamageAssessment;
        return this;
    }

    public boolean useNormalization() {
        return this.useNormalization;
    }

    public ImpactMethodBlock useNormalization(boolean useNormalization) {
        this.useNormalization = useNormalization;
        return this;
    }

    public boolean useWeighting() {
        return this.useWeighting;
    }

    public ImpactMethodBlock useWeighting(boolean useWeighting) {
        this.useWeighting = useWeighting;
        return this;
    }

    public boolean useAddition() {
        return this.useAddition;
    }

    public ImpactMethodBlock useAddition(boolean useAddition) {
        this.useAddition = useAddition;
        return this;
    }

    public String weightingUnit() {
        return this.weightingUnit;
    }

    public ImpactMethodBlock weightingUnit(String weightingUnit) {
        this.weightingUnit = weightingUnit;
        return this;
    }

    public List<ImpactCategoryBlock> impactCategories() {
        return this.impactCategories;
    }

    public List<DamageCategoryBlock> damageCategories() {
        return this.damageCategories;
    }

    public List<NwSetBlock> nwSets() {
        return this.nwSets;
    }

    public static ImpactMethodBlock read(Iterable<CsvLine> lines) {
        Iterator<CsvLine> iter = lines.iterator();
        ImpactMethodBlock method = new ImpactMethodBlock();
        String innerHeader = null;
        while (iter.hasNext()) {
            String header;
            if (innerHeader != null) {
                header = innerHeader;
            } else {
                CsvLine next = iter.next();
                if (next.isEmpty()) continue;
                header = next.first();
            }
            if (header.equalsIgnoreCase("End")) break;
            block14 : switch (header) {
                case "Name": {
                    method.name(CsvLine.nextString(iter));
                    break;
                }
                case "Version": {
                    CsvLine.nextOf(iter).ifPresent(nextLine -> method.version(VersionRow.read(nextLine)));
                    break;
                }
                case "Comment": {
                    method.comment(CsvLine.nextString(iter));
                    break;
                }
                case "Category": {
                    method.category(CsvLine.nextString(iter));
                    break;
                }
                case "Use Damage Assessment": {
                    method.useDamageAssessment(CsvLine.nextBool(iter));
                    break;
                }
                case "Use Normalization": {
                    method.useNormalization(CsvLine.nextBool(iter));
                    break;
                }
                case "Use Weighting": {
                    method.useWeighting(CsvLine.nextBool(iter));
                    break;
                }
                case "Use Addition": {
                    method.useAddition(CsvLine.nextBool(iter));
                    break;
                }
                case "Weighting unit": {
                    method.weightingUnit(CsvLine.nextString(iter));
                    break;
                }
                case "Impact category": {
                    ImpactCategoryBlock impactCategory = new ImpactCategoryBlock();
                    CsvLine.nextOf(iter).ifPresent(nextLine -> impactCategory.info(ImpactCategoryRow.read(nextLine)));
                    CsvLine.moveTo(iter, "Substances");
                    CsvLine.untilEmpty(iter, nextLine -> {
                        ImpactFactorRow factor = ImpactFactorRow.read(nextLine);
                        impactCategory.factors().add(factor);
                    });
                    method.impactCategories().add(impactCategory);
                    break;
                }
                case "Damage category": {
                    DamageCategoryBlock damageCategory = new DamageCategoryBlock();
                    CsvLine.nextOf(iter).ifPresent(nextLine -> damageCategory.info(DamageCategoryRow.read(nextLine)));
                    CsvLine.moveTo(iter, "Impact categories");
                    CsvLine.untilEmpty(iter, nextLine -> {
                        DamageFactorRow factor = DamageFactorRow.read(nextLine);
                        damageCategory.factors().add(factor);
                    });
                    method.damageCategories().add(damageCategory);
                    break;
                }
                case "Normalization-Weighting set": {
                    NwSetBlock nwSet = new NwSetBlock();
                    nwSet.name(CsvLine.nextString(iter));
                    method.nwSets().add(nwSet);
                    while (iter.hasNext()) {
                        CsvLine nwRow = iter.next();
                        if (nwRow.isEmpty()) continue;
                        String nwHeader = nwRow.first();
                        if ("Normalization".equals(nwHeader)) {
                            CsvLine.untilEmpty(iter, nextLine -> {
                                NwSetFactorRow factor = NwSetFactorRow.read(nextLine);
                                nwSet.normalizationFactors().add(factor);
                            });
                            continue;
                        }
                        if ("Weighting".equals(nwHeader)) {
                            CsvLine.untilEmpty(iter, nextLine -> {
                                NwSetFactorRow factor = NwSetFactorRow.read(nextLine);
                                nwSet.weightingFactors().add(factor);
                            });
                            continue;
                        }
                        innerHeader = nwHeader;
                        break block14;
                    }
                    break;
                }
            }
        }
        return method;
    }

    @Override
    public void write(CsvBuffer buffer) {
        buffer.putString("Method").writeln().writeln();
        buffer.putString("Name").writeln().putString(this.name()).writeln().writeln();
        buffer.putString("Version").writeln().putRecord(this.version()).writeln();
        buffer.putString("Comment").writeln().putString(this.comment()).writeln().writeln();
        String c = this.category();
        if (c == null || c.isEmpty()) {
            c = "Others";
        }
        buffer.putString("Category").writeln().putString(c).writeln().writeln();
        buffer.putString("Use Damage Assessment").writeln().putBoolean(this.useDamageAssessment()).writeln().writeln();
        buffer.putString("Use Normalization").writeln().putBoolean(this.useNormalization()).writeln().writeln();
        buffer.putString("Use Weighting").writeln().putBoolean(this.useWeighting()).writeln().writeln();
        buffer.putString("Use Addition").writeln().putBoolean(this.useAddition()).writeln().writeln();
        buffer.putString("Weighting unit").writeln().putString(this.weightingUnit()).writeln().writeln();
        buffer.putRecords(this.impactCategories()).writeln();
        buffer.putRecords(this.damageCategories()).writeln();
        buffer.putRecords(this.nwSets()).writeln();
        buffer.putString("End").writeln().writeln();
    }
}

