/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.openlca.simapro.csv.CsvBlock;
import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvLine;
import org.openlca.simapro.csv.CsvRecord;
import org.openlca.simapro.csv.enums.ElementaryFlowType;
import org.openlca.simapro.csv.enums.ProcessCategory;
import org.openlca.simapro.csv.enums.ProcessType;
import org.openlca.simapro.csv.enums.ProductType;
import org.openlca.simapro.csv.enums.Status;
import org.openlca.simapro.csv.process.ElementaryExchangeRow;
import org.openlca.simapro.csv.process.LiteratureRow;
import org.openlca.simapro.csv.process.ProductOutputRow;
import org.openlca.simapro.csv.process.SystemDescriptionRow;
import org.openlca.simapro.csv.process.TechExchangeRow;
import org.openlca.simapro.csv.process.WasteFractionRow;
import org.openlca.simapro.csv.process.WasteTreatmentRow;
import org.openlca.simapro.csv.refdata.CalculatedParameterRow;
import org.openlca.simapro.csv.refdata.InputParameterRow;

public class ProcessBlock
implements CsvBlock {
    private String platformId;
    private ProcessCategory category;
    private String identifier;
    private ProcessType processType;
    private String name;
    private Status status;
    private Boolean infrastructure;
    private Date date;
    private String record;
    private String generator;
    private String collectionMethod;
    private String verification;
    private String comment;
    private String allocationRules;
    private String dataTreatment;
    private SystemDescriptionRow systemDescription;
    private WasteTreatmentRow wasteTreatment;
    private WasteTreatmentRow wasteScenario;
    private final List<LiteratureRow> literatures = new ArrayList<LiteratureRow>();
    private final List<ProductOutputRow> products = new ArrayList<ProductOutputRow>();
    private final List<TechExchangeRow> avoidedProducts = new ArrayList<TechExchangeRow>();
    private final List<TechExchangeRow> materialsAndFuels = new ArrayList<TechExchangeRow>();
    private final List<TechExchangeRow> electricityAndHeat = new ArrayList<TechExchangeRow>();
    private final List<TechExchangeRow> wasteToTreatment = new ArrayList<TechExchangeRow>();
    private final List<WasteFractionRow> separatedWaste = new ArrayList<WasteFractionRow>();
    private final List<WasteFractionRow> remainingWaste = new ArrayList<WasteFractionRow>();
    private final List<ElementaryExchangeRow> resources = new ArrayList<ElementaryExchangeRow>();
    private final List<ElementaryExchangeRow> emissionsToAir = new ArrayList<ElementaryExchangeRow>();
    private final List<ElementaryExchangeRow> emissionsToWater = new ArrayList<ElementaryExchangeRow>();
    private final List<ElementaryExchangeRow> emissionsToSoil = new ArrayList<ElementaryExchangeRow>();
    private final List<ElementaryExchangeRow> finalWasteFlows = new ArrayList<ElementaryExchangeRow>();
    private final List<ElementaryExchangeRow> nonMaterialEmissions = new ArrayList<ElementaryExchangeRow>();
    private final List<ElementaryExchangeRow> socialIssues = new ArrayList<ElementaryExchangeRow>();
    private final List<ElementaryExchangeRow> economicIssues = new ArrayList<ElementaryExchangeRow>();
    private final List<InputParameterRow> inputParameters = new ArrayList<InputParameterRow>();
    private final List<CalculatedParameterRow> calculatedParameters = new ArrayList<CalculatedParameterRow>();

    public String platformId() {
        return this.platformId;
    }

    public ProcessBlock platformId(String platformId) {
        this.platformId = platformId;
        return this;
    }

    public ProcessCategory category() {
        return this.category;
    }

    public ProcessBlock category(ProcessCategory category) {
        this.category = category;
        return this;
    }

    public String identifier() {
        return this.identifier;
    }

    public ProcessBlock identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ProcessType processType() {
        return this.processType;
    }

    public ProcessBlock processType(ProcessType processType) {
        this.processType = processType;
        return this;
    }

    public String name() {
        return this.name;
    }

    public ProcessBlock name(String name) {
        this.name = name;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public ProcessBlock status(Status status) {
        this.status = status;
        return this;
    }

    public Boolean infrastructure() {
        return this.infrastructure;
    }

    public ProcessBlock infrastructure(Boolean infrastructure) {
        this.infrastructure = infrastructure;
        return this;
    }

    public Date date() {
        return this.date;
    }

    public ProcessBlock date(Date date) {
        this.date = date;
        return this;
    }

    public String record() {
        return this.record;
    }

    public ProcessBlock record(String record) {
        this.record = record;
        return this;
    }

    public String generator() {
        return this.generator;
    }

    public ProcessBlock generator(String generator) {
        this.generator = generator;
        return this;
    }

    public String collectionMethod() {
        return this.collectionMethod;
    }

    public ProcessBlock collectionMethod(String collectionMethod) {
        this.collectionMethod = collectionMethod;
        return this;
    }

    public String verification() {
        return this.verification;
    }

    public ProcessBlock verification(String verification) {
        this.verification = verification;
        return this;
    }

    public String comment() {
        return this.comment;
    }

    public ProcessBlock comment(String comment) {
        this.comment = comment;
        return this;
    }

    public String allocationRules() {
        return this.allocationRules;
    }

    public ProcessBlock allocationRules(String allocationRules) {
        this.allocationRules = allocationRules;
        return this;
    }

    public String dataTreatment() {
        return this.dataTreatment;
    }

    public ProcessBlock dataTreatment(String dataTreatment) {
        this.dataTreatment = dataTreatment;
        return this;
    }

    public SystemDescriptionRow systemDescription() {
        return this.systemDescription;
    }

    public ProcessBlock systemDescription(SystemDescriptionRow systemDescription) {
        this.systemDescription = systemDescription;
        return this;
    }

    public WasteTreatmentRow wasteTreatment() {
        return this.wasteTreatment;
    }

    public ProcessBlock wasteTreatment(WasteTreatmentRow wasteTreatment) {
        this.wasteTreatment = wasteTreatment;
        return this;
    }

    public WasteTreatmentRow wasteScenario() {
        return this.wasteScenario;
    }

    public ProcessBlock wasteScenario(WasteTreatmentRow wasteScenario) {
        this.wasteScenario = wasteScenario;
        return this;
    }

    public List<LiteratureRow> literatures() {
        return this.literatures;
    }

    public List<ProductOutputRow> products() {
        return this.products;
    }

    public List<TechExchangeRow> avoidedProducts() {
        return this.avoidedProducts;
    }

    public List<TechExchangeRow> materialsAndFuels() {
        return this.materialsAndFuels;
    }

    public List<TechExchangeRow> electricityAndHeat() {
        return this.electricityAndHeat;
    }

    public List<TechExchangeRow> wasteToTreatment() {
        return this.wasteToTreatment;
    }

    public List<WasteFractionRow> separatedWaste() {
        return this.separatedWaste;
    }

    public List<WasteFractionRow> remainingWaste() {
        return this.remainingWaste;
    }

    public List<ElementaryExchangeRow> resources() {
        return this.resources;
    }

    public List<ElementaryExchangeRow> emissionsToAir() {
        return this.emissionsToAir;
    }

    public List<ElementaryExchangeRow> emissionsToWater() {
        return this.emissionsToWater;
    }

    public List<ElementaryExchangeRow> emissionsToSoil() {
        return this.emissionsToSoil;
    }

    public List<ElementaryExchangeRow> finalWasteFlows() {
        return this.finalWasteFlows;
    }

    public List<ElementaryExchangeRow> nonMaterialEmissions() {
        return this.nonMaterialEmissions;
    }

    public List<ElementaryExchangeRow> socialIssues() {
        return this.socialIssues;
    }

    public List<ElementaryExchangeRow> economicIssues() {
        return this.economicIssues;
    }

    public List<InputParameterRow> inputParameters() {
        return this.inputParameters;
    }

    public List<CalculatedParameterRow> calculatedParameters() {
        return this.calculatedParameters;
    }

    public static ProcessBlock read(Iterable<CsvLine> lines) {
        Iterator<CsvLine> iter = lines.iterator();
        ProcessBlock process = new ProcessBlock();
        Supplier<String> nextFirst = () -> CsvLine.nextOf(iter).map(CsvLine::first).orElse("");
        while (iter.hasNext()) {
            CsvLine next = iter.next();
            if (next.isEmpty()) continue;
            String header = next.first();
            if (header.equalsIgnoreCase("End")) break;
            if (header.isEmpty()) continue;
            switch (header) {
                case "PlatformId": {
                    process.platformId(nextFirst.get());
                    break;
                }
                case "Category type": {
                    ProcessCategory category = ProcessCategory.of(nextFirst.get());
                    process.category(category);
                    break;
                }
                case "Process identifier": {
                    process.identifier(nextFirst.get());
                    break;
                }
                case "Type": {
                    ProcessType processType = ProcessType.of(nextFirst.get());
                    process.processType(processType);
                    break;
                }
                case "Process name": {
                    process.name(nextFirst.get());
                    break;
                }
                case "Status": {
                    Status status = Status.of(nextFirst.get());
                    process.status(status);
                    break;
                }
                case "Infrastructure": {
                    CsvLine.nextOf(iter).ifPresent(line -> process.infrastructure(line.getBoolean(0)));
                    break;
                }
                case "Date": {
                    CsvLine.nextOf(iter).ifPresent(line -> process.date(line.getDate(0)));
                    break;
                }
                case "Record": {
                    process.record(nextFirst.get());
                    break;
                }
                case "Generator": {
                    process.generator(nextFirst.get());
                    break;
                }
                case "Literature references": {
                    CsvLine.untilEmpty(iter, line -> process.literatures.add(LiteratureRow.read(line)));
                    break;
                }
                case "Collection method": {
                    process.collectionMethod(nextFirst.get());
                    break;
                }
                case "Verification": {
                    process.verification(nextFirst.get());
                    break;
                }
                case "Comment": {
                    process.comment(nextFirst.get());
                    break;
                }
                case "Allocation rules": {
                    process.allocationRules(nextFirst.get());
                    break;
                }
                case "System description": {
                    CsvLine.nextOf(iter).ifPresent(line -> process.systemDescription(SystemDescriptionRow.read(line)));
                    break;
                }
                case "Data treatment": {
                    process.dataTreatment(nextFirst.get());
                    break;
                }
                case "Products": {
                    CsvLine.untilEmpty(iter, line -> process.products.add(ProductOutputRow.read(line)));
                    break;
                }
                case "Waste treatment": {
                    CsvLine.nextOf(iter).ifPresent(line -> process.wasteTreatment(WasteTreatmentRow.read(line)));
                    break;
                }
                case "Waste scenario": {
                    CsvLine.nextOf(iter).ifPresent(line -> process.wasteScenario(WasteTreatmentRow.read(line)));
                }
                case "Avoided products": {
                    CsvLine.untilEmpty(iter, line -> process.avoidedProducts.add(TechExchangeRow.read(line)));
                    break;
                }
                case "Materials/fuels": {
                    CsvLine.untilEmpty(iter, line -> process.materialsAndFuels.add(TechExchangeRow.read(line)));
                    break;
                }
                case "Electricity/heat": {
                    CsvLine.untilEmpty(iter, line -> process.electricityAndHeat.add(TechExchangeRow.read(line)));
                    break;
                }
                case "Waste to treatment": {
                    CsvLine.untilEmpty(iter, line -> process.wasteToTreatment.add(TechExchangeRow.read(line)));
                    break;
                }
                case "Separated waste": {
                    CsvLine.untilEmpty(iter, line -> process.separatedWaste.add(WasteFractionRow.read(line)));
                    break;
                }
                case "Remaining waste": {
                    CsvLine.untilEmpty(iter, line -> process.remainingWaste.add(WasteFractionRow.read(line)));
                    break;
                }
                case "Resources": {
                    CsvLine.untilEmpty(iter, line -> process.resources.add(ElementaryExchangeRow.read(line)));
                    break;
                }
                case "Emissions to air": {
                    CsvLine.untilEmpty(iter, line -> process.emissionsToAir.add(ElementaryExchangeRow.read(line)));
                    break;
                }
                case "Emissions to water": {
                    CsvLine.untilEmpty(iter, line -> process.emissionsToWater.add(ElementaryExchangeRow.read(line)));
                    break;
                }
                case "Emissions to soil": {
                    CsvLine.untilEmpty(iter, line -> process.emissionsToSoil.add(ElementaryExchangeRow.read(line)));
                    break;
                }
                case "Final waste flows": {
                    CsvLine.untilEmpty(iter, line -> process.finalWasteFlows.add(ElementaryExchangeRow.read(line)));
                    break;
                }
                case "Non material emissions": {
                    CsvLine.untilEmpty(iter, line -> process.nonMaterialEmissions.add(ElementaryExchangeRow.read(line)));
                    break;
                }
                case "Social issues": {
                    CsvLine.untilEmpty(iter, line -> process.socialIssues.add(ElementaryExchangeRow.read(line)));
                    break;
                }
                case "Economic issues": {
                    CsvLine.untilEmpty(iter, line -> process.economicIssues.add(ElementaryExchangeRow.read(line)));
                    break;
                }
                case "Input parameters": {
                    CsvLine.untilEmpty(iter, line -> process.inputParameters.add(InputParameterRow.read(line)));
                    break;
                }
                case "Calculated parameters": {
                    CsvLine.untilEmpty(iter, line -> process.calculatedParameters.add(CalculatedParameterRow.read(line)));
                }
            }
        }
        return process;
    }

    @Override
    public void write(CsvBuffer buffer) {
        buffer.putString("Process").writeln().writeln();
        if (this.platformId != null) {
            buffer.putString("PlatformId").writeln().putString(this.platformId).writeln().writeln();
        }
        buffer.putString("Category type").writeln();
        buffer.putString(this.category == null ? ProcessCategory.MATERIAL.toString() : this.category.toString()).writeln().writeln();
        if (this.identifier != null) {
            buffer.putString("Process identifier").writeln().putString(this.identifier).writeln().writeln();
        }
        buffer.putString("Type").writeln();
        buffer.putString(this.processType == null ? ProcessType.UNIT_PROCESS.toString() : this.processType.toString()).writeln().writeln();
        if (this.name != null) {
            buffer.putString("Process name").writeln().putString(this.name).writeln().writeln();
        }
        buffer.putString("Status").writeln().putString(this.status == null ? Status.NONE.toString() : this.status.toString()).writeln().writeln();
        if (this.infrastructure != null) {
            buffer.putString("Infrastructure").writeln().putString(this.infrastructure != false ? "Yes" : "No").writeln().writeln();
        }
        if (this.date != null) {
            buffer.putString("Date").writeln().putDate(this.date).writeln().writeln();
        }
        if (this.record != null) {
            buffer.putString("Record").writeln().putString(this.record).writeln().writeln();
        }
        if (this.generator != null) {
            buffer.putString("Generator").writeln().putString(this.generator).writeln().writeln();
        }
        this.writeRows(buffer, "Literature references", this.literatures);
        if (this.collectionMethod != null) {
            buffer.putString("Collection method").writeln().putString(this.collectionMethod).writeln().writeln();
        }
        if (this.dataTreatment != null) {
            buffer.putString("Data treatment").writeln().putString(this.dataTreatment).writeln().writeln();
        }
        if (this.verification != null) {
            buffer.putString("Verification").writeln().putString(this.verification).writeln().writeln();
        }
        if (this.comment != null) {
            buffer.putString("Comment").writeln().putString(this.comment).writeln().writeln();
        }
        if (this.allocationRules != null) {
            buffer.putString("Allocation rules").writeln().putString(this.allocationRules).writeln().writeln();
        }
        this.writeRow(buffer, "System description", this.systemDescription);
        this.writeRows(buffer, "Products", this.products);
        this.writeRow(buffer, "Waste scenario", this.wasteScenario);
        this.writeRows(buffer, "Avoided products", this.avoidedProducts);
        this.writeRows(buffer, "Resources", this.resources);
        this.writeRow(buffer, "Waste treatment", this.wasteTreatment);
        this.writeRows(buffer, "Materials/fuels", this.materialsAndFuels);
        this.writeRows(buffer, "Electricity/heat", this.electricityAndHeat);
        this.writeRows(buffer, "Emissions to air", this.emissionsToAir);
        this.writeRows(buffer, "Emissions to water", this.emissionsToWater);
        this.writeRows(buffer, "Emissions to soil", this.emissionsToSoil);
        this.writeRows(buffer, "Final waste flows", this.finalWasteFlows);
        this.writeRows(buffer, "Non material emissions", this.nonMaterialEmissions);
        this.writeRows(buffer, "Social issues", this.socialIssues);
        this.writeRows(buffer, "Economic issues", this.economicIssues);
        this.writeRows(buffer, "Waste to treatment", this.wasteToTreatment);
        this.writeRows(buffer, "Separated waste", this.separatedWaste);
        this.writeRows(buffer, "Remaining waste", this.remainingWaste);
        this.writeRows(buffer, "Input parameters", this.inputParameters);
        this.writeRows(buffer, "Calculated parameters", this.calculatedParameters);
        buffer.writeln().putString("End").writeln().writeln();
    }

    public List<ElementaryExchangeRow> exchangesOf(ElementaryFlowType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        switch (type) {
            case ECONOMIC_ISSUES: {
                return this.economicIssues;
            }
            case EMISSIONS_TO_AIR: {
                return this.emissionsToAir;
            }
            case EMISSIONS_TO_SOIL: {
                return this.emissionsToSoil;
            }
            case EMISSIONS_TO_WATER: {
                return this.emissionsToWater;
            }
            case FINAL_WASTE_FLOWS: {
                return this.finalWasteFlows;
            }
            case NON_MATERIAL_EMISSIONS: {
                return this.nonMaterialEmissions;
            }
            case RESOURCES: {
                return this.resources;
            }
            case SOCIAL_ISSUES: {
                return this.socialIssues;
            }
        }
        return Collections.emptyList();
    }

    public List<TechExchangeRow> exchangesOf(ProductType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        switch (type) {
            case AVOIDED_PRODUCTS: {
                return this.avoidedProducts;
            }
            case ELECTRICITY_HEAT: {
                return this.electricityAndHeat;
            }
            case MATERIAL_FUELS: {
                return this.materialsAndFuels;
            }
            case WASTE_TO_TREATMENT: {
                return this.wasteToTreatment;
            }
        }
        return Collections.emptyList();
    }

    private void writeRows(CsvBuffer buffer, String header, List<? extends CsvRecord> rows) {
        if (rows.isEmpty()) {
            return;
        }
        buffer.putString(header).writeln();
        for (CsvRecord csvRecord : rows) {
            csvRecord.write(buffer);
        }
        buffer.writeln();
    }

    private <T extends CsvRecord> void writeRow(CsvBuffer buffer, String header, T row) {
        if (row == null) {
            return;
        }
        buffer.putString(header).writeln();
        row.write(buffer);
        buffer.writeln();
    }
}

