/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.process;

import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvLine;
import org.openlca.simapro.csv.CsvRecord;
import org.openlca.simapro.csv.Numeric;
import org.openlca.simapro.csv.process.RefExchangeRow;

public class ProductOutputRow
implements CsvRecord,
RefExchangeRow {
    private String name;
    private String unit;
    private Numeric amount;
    private Numeric allocation;
    private String wasteType;
    private String category;
    private String comment;
    private String platformId;

    @Override
    public String name() {
        return this.name;
    }

    public ProductOutputRow name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String unit() {
        return this.unit;
    }

    public ProductOutputRow unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public Numeric amount() {
        return this.amount == null ? Numeric.zero() : this.amount;
    }

    public ProductOutputRow amount(Numeric amount) {
        this.amount = amount;
        return this;
    }

    public Numeric allocation() {
        return this.allocation == null ? Numeric.zero() : this.allocation;
    }

    public ProductOutputRow allocation(Numeric allocation) {
        this.allocation = allocation;
        return this;
    }

    public String wasteType() {
        return this.wasteType;
    }

    public ProductOutputRow wasteType(String wasteType) {
        this.wasteType = wasteType;
        return this;
    }

    @Override
    public String category() {
        return this.category;
    }

    public ProductOutputRow category(String category) {
        this.category = category;
        return this;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public ProductOutputRow comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public String platformId() {
        return this.platformId;
    }

    public ProductOutputRow platformId(String platformId) {
        this.platformId = platformId;
        return this;
    }

    public static ProductOutputRow read(CsvLine line) {
        return new ProductOutputRow().name(line.getString(0)).unit(line.getString(1)).amount(line.getNumeric(2)).allocation(line.getNumeric(3)).wasteType(line.getString(4)).category(line.getString(5)).comment(line.getString(6)).platformId(line.getString(7));
    }

    @Override
    public void write(CsvBuffer buffer) {
        buffer.putString(this.name).putString(this.unit).putNumeric(this.amount).putNumeric(this.allocation).putString(this.wasteType).putString(this.category).putString(this.comment).putString(this.platformId).writeln();
    }
}

