/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.process;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openlca.simapro.csv.CsvBlock;
import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvLine;
import org.openlca.simapro.csv.CsvRecord;
import org.openlca.simapro.csv.enums.ProductStageCategory;
import org.openlca.simapro.csv.enums.Status;
import org.openlca.simapro.csv.process.ProductStageOutputRow;
import org.openlca.simapro.csv.process.TechExchangeRow;
import org.openlca.simapro.csv.refdata.CalculatedParameterRow;
import org.openlca.simapro.csv.refdata.InputParameterRow;

public class ProductStageBlock
implements CsvBlock {
    private ProductStageCategory category;
    private Status status;
    private TechExchangeRow assembly;
    private TechExchangeRow referenceAssembly;
    private TechExchangeRow wasteOrDisposalScenario;
    private final List<ProductStageOutputRow> products = new ArrayList<ProductStageOutputRow>();
    private final List<TechExchangeRow> materialsAndAssemblies = new ArrayList<TechExchangeRow>();
    private final List<TechExchangeRow> processes = new ArrayList<TechExchangeRow>();
    private final List<TechExchangeRow> wasteScenarios = new ArrayList<TechExchangeRow>();
    private final List<TechExchangeRow> disassemblies = new ArrayList<TechExchangeRow>();
    private final List<TechExchangeRow> disposalScenarios = new ArrayList<TechExchangeRow>();
    private final List<TechExchangeRow> reuses = new ArrayList<TechExchangeRow>();
    private final List<TechExchangeRow> additionalLifeCycles = new ArrayList<TechExchangeRow>();
    private final List<InputParameterRow> inputParameters = new ArrayList<InputParameterRow>();
    private final List<CalculatedParameterRow> calculatedParameters = new ArrayList<CalculatedParameterRow>();

    public ProductStageCategory category() {
        return this.category;
    }

    public ProductStageBlock category(ProductStageCategory category) {
        this.category = category;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public ProductStageBlock status(Status status) {
        this.status = status;
        return this;
    }

    public TechExchangeRow referenceAssembly() {
        return this.referenceAssembly;
    }

    public ProductStageBlock referenceAssembly(TechExchangeRow referenceAssembly) {
        this.referenceAssembly = referenceAssembly;
        return this;
    }

    public TechExchangeRow assembly() {
        return this.assembly;
    }

    public ProductStageBlock assembly(TechExchangeRow assembly) {
        this.assembly = assembly;
        return this;
    }

    public TechExchangeRow wasteOrDisposalScenario() {
        return this.wasteOrDisposalScenario;
    }

    public ProductStageBlock wasteOrDisposalScenario(TechExchangeRow wasteOrDisposalScenario) {
        this.wasteOrDisposalScenario = wasteOrDisposalScenario;
        return this;
    }

    public List<ProductStageOutputRow> products() {
        return this.products;
    }

    public List<TechExchangeRow> materialsAndAssemblies() {
        return this.materialsAndAssemblies;
    }

    public List<TechExchangeRow> processes() {
        return this.processes;
    }

    public List<TechExchangeRow> wasteScenarios() {
        return this.wasteScenarios;
    }

    public List<TechExchangeRow> disassemblies() {
        return this.disassemblies;
    }

    public List<TechExchangeRow> disposalScenarios() {
        return this.disposalScenarios;
    }

    public List<TechExchangeRow> reuses() {
        return this.reuses;
    }

    public List<InputParameterRow> inputParameters() {
        return this.inputParameters;
    }

    public List<CalculatedParameterRow> calculatedParameters() {
        return this.calculatedParameters;
    }

    public List<TechExchangeRow> additionalLifeCycles() {
        return this.additionalLifeCycles;
    }

    public static ProductStageBlock read(Iterable<CsvLine> lines) {
        Iterator<CsvLine> iter = lines.iterator();
        ProductStageBlock block = new ProductStageBlock();
        Supplier<String> nextFirst = () -> CsvLine.nextOf(iter).map(CsvLine::first).orElse("");
        Consumer<Consumer> nextTechExchange = setter -> CsvLine.nextOf(iter).ifPresent(nextLine -> {
            if (nextLine.isEmpty()) {
                return;
            }
            TechExchangeRow row = TechExchangeRow.read(nextLine);
            setter.accept(row);
        });
        Consumer<List> nextTechExchanges = list -> CsvLine.untilEmpty(iter, nextLine -> {
            TechExchangeRow row = TechExchangeRow.read(nextLine);
            list.add(row);
        });
        while (iter.hasNext()) {
            CsvLine line = iter.next();
            if (line.isEmpty()) continue;
            String header = line.first();
            if (header.equalsIgnoreCase("End")) break;
            if (header.isEmpty()) continue;
            switch (header) {
                case "Category type": {
                    ProductStageCategory category = ProductStageCategory.of(nextFirst.get());
                    block.category(category);
                    break;
                }
                case "Status": {
                    Status status = Status.of(nextFirst.get());
                    block.status(status);
                    break;
                }
                case "Products": {
                    CsvLine.untilEmpty(iter, nextLine -> {
                        ProductStageOutputRow row = ProductStageOutputRow.read(nextLine);
                        block.products.add(row);
                    });
                    break;
                }
                case "Assembly": {
                    nextTechExchange.accept(block::assembly);
                    break;
                }
                case "Waste/Disposal scenario": {
                    nextTechExchange.accept(block::wasteOrDisposalScenario);
                    break;
                }
                case "Reference assembly": {
                    nextTechExchange.accept(block::referenceAssembly);
                    break;
                }
                case "Materials/assemblies": {
                    nextTechExchanges.accept(block.materialsAndAssemblies);
                    break;
                }
                case "Processes": {
                    nextTechExchanges.accept(block.processes);
                    break;
                }
                case "Disposal scenarios": {
                    nextTechExchanges.accept(block.disposalScenarios);
                    break;
                }
                case "Waste scenarios": {
                    nextTechExchanges.accept(block.wasteScenarios);
                    break;
                }
                case "Disassemblies": {
                    nextTechExchanges.accept(block.disassemblies);
                    break;
                }
                case "Reuses": {
                    nextTechExchanges.accept(block.reuses);
                    break;
                }
                case "Additional life cycles": {
                    nextTechExchanges.accept(block.additionalLifeCycles);
                    break;
                }
                case "Input parameters": {
                    CsvLine.untilEmpty(iter, nextLine -> {
                        InputParameterRow row = InputParameterRow.read(nextLine);
                        block.inputParameters.add(row);
                    });
                    break;
                }
                case "Calculated parameters": {
                    CsvLine.untilEmpty(iter, nextLine -> {
                        CalculatedParameterRow row = CalculatedParameterRow.read(nextLine);
                        block.calculatedParameters.add(row);
                    });
                }
            }
        }
        return block;
    }

    @Override
    public void write(CsvBuffer buffer) {
        buffer.putString("Product stage").writeln().writeln();
        buffer.putString("Category type").writeln();
        buffer.putString(this.category == null ? ProductStageCategory.ASSEMBLY.toString() : this.category.toString()).writeln().writeln();
        buffer.putString("Status").writeln().putString(this.status == null ? Status.NONE.toString() : this.status.toString()).writeln().writeln();
        this.writeRows(buffer, "Products", this.products);
        if (this.assembly != null) {
            buffer.putString("Assembly").writeln().putRecord(this.assembly).writeln();
        }
        if (this.referenceAssembly != null) {
            buffer.putString("Reference assembly").writeln().putRecord(this.referenceAssembly).writeln();
        }
        this.writeRows(buffer, "Materials/assemblies", this.materialsAndAssemblies);
        this.writeRows(buffer, "Processes", this.processes);
        if (this.wasteOrDisposalScenario != null) {
            buffer.putString("Waste/Disposal scenario").writeln().putRecord(this.wasteOrDisposalScenario).writeln();
        }
        this.writeRows(buffer, "Additional life cycles", this.additionalLifeCycles);
        this.writeRows(buffer, "Disposal scenarios", this.disposalScenarios);
        this.writeRows(buffer, "Waste scenarios", this.wasteScenarios);
        this.writeRows(buffer, "Disassemblies", this.disassemblies);
        this.writeRows(buffer, "Reuses", this.reuses);
        this.writeRows(buffer, "Input parameters", this.inputParameters);
        this.writeRows(buffer, "Calculated parameters", this.calculatedParameters);
        buffer.writeln().putString("End").writeln().writeln();
    }

    private void writeRows(CsvBuffer buffer, String header, List<? extends CsvRecord> rows) {
        if (rows.isEmpty()) {
            return;
        }
        buffer.putString(header).writeln();
        for (CsvRecord csvRecord : rows) {
            csvRecord.write(buffer);
        }
        buffer.writeln();
    }
}

