/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.refdata;

import java.util.ArrayList;
import java.util.List;
import org.openlca.simapro.csv.CsvBlock;
import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvLine;
import org.openlca.simapro.csv.refdata.CalculatedParameterRow;

public class CalculatedParameterBlock
implements CsvBlock {
    private final boolean forProject;
    private final List<CalculatedParameterRow> parameters = new ArrayList<CalculatedParameterRow>();

    private CalculatedParameterBlock(boolean forProject) {
        this.forProject = forProject;
    }

    public static CalculatedParameterBlock forProject() {
        return new CalculatedParameterBlock(true);
    }

    public static CalculatedParameterBlock forDatabase() {
        return new CalculatedParameterBlock(false);
    }

    public boolean isForProject() {
        return this.forProject;
    }

    public boolean isForDatabase() {
        return !this.forProject;
    }

    public List<CalculatedParameterRow> parameters() {
        return this.parameters;
    }

    public static CalculatedParameterBlock readProjectParameters(Iterable<CsvLine> lines) {
        return CalculatedParameterBlock.read(true, lines);
    }

    public static CalculatedParameterBlock readDatabaseParameters(Iterable<CsvLine> lines) {
        return CalculatedParameterBlock.read(false, lines);
    }

    private static CalculatedParameterBlock read(boolean forProject, Iterable<CsvLine> lines) {
        CalculatedParameterBlock block = new CalculatedParameterBlock(forProject);
        for (CsvLine line : lines) {
            if (line.first().equals("Project Calculated parameters") || line.first().equals("Database Calculated parameters")) continue;
            if (line.isEmpty()) break;
            CalculatedParameterRow row = CalculatedParameterRow.read(line);
            block.parameters.add(row);
        }
        return block;
    }

    @Override
    public void write(CsvBuffer buffer) {
        String header = this.forProject ? "Project Calculated parameters" : "Database Calculated parameters";
        buffer.putString(header).writeln().putRecords(this.parameters).writeln().putString("End").writeln().writeln();
    }
}

