/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.refdata;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openlca.simapro.csv.CsvBlock;
import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvLine;
import org.openlca.simapro.csv.enums.ElementaryFlowType;
import org.openlca.simapro.csv.refdata.ElementaryFlowRow;

public class ElementaryFlowBlock
implements CsvBlock {
    private final ElementaryFlowType type;
    private final List<ElementaryFlowRow> flows = new ArrayList<ElementaryFlowRow>();

    private ElementaryFlowBlock(ElementaryFlowType type) {
        this.type = Objects.requireNonNull(type);
    }

    public static ElementaryFlowBlock of(ElementaryFlowType type) {
        return new ElementaryFlowBlock(type);
    }

    public ElementaryFlowType type() {
        return this.type;
    }

    public List<ElementaryFlowRow> flows() {
        return this.flows;
    }

    public static ElementaryFlowBlock read(ElementaryFlowType type, Iterable<CsvLine> lines) {
        ElementaryFlowBlock block = new ElementaryFlowBlock(type);
        for (CsvLine line : lines) {
            if (line.first().equals(type.blockHeader())) continue;
            if (line.isEmpty()) break;
            ElementaryFlowRow row = ElementaryFlowRow.read(line);
            block.flows.add(row);
        }
        return block;
    }

    @Override
    public void write(CsvBuffer buffer) {
        buffer.putString(this.type.blockHeader()).writeln().putRecords(this.flows).writeln().putString("End").writeln().writeln();
    }
}

