/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.refdata;

import java.util.ArrayList;
import java.util.List;
import org.openlca.simapro.csv.CsvBlock;
import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvLine;
import org.openlca.simapro.csv.refdata.InputParameterRow;

public class InputParameterBlock
implements CsvBlock {
    private final boolean forProject;
    private final List<InputParameterRow> parameters = new ArrayList<InputParameterRow>();

    private InputParameterBlock(boolean forProject) {
        this.forProject = forProject;
    }

    public static InputParameterBlock forProject() {
        return new InputParameterBlock(true);
    }

    public static InputParameterBlock forDatabase() {
        return new InputParameterBlock(false);
    }

    public boolean isForProject() {
        return this.forProject;
    }

    public boolean isForDatabase() {
        return !this.forProject;
    }

    public List<InputParameterRow> parameters() {
        return this.parameters;
    }

    public static InputParameterBlock readProjectParameters(Iterable<CsvLine> lines) {
        return InputParameterBlock.read(true, lines);
    }

    public static InputParameterBlock readDatabaseParameters(Iterable<CsvLine> lines) {
        return InputParameterBlock.read(false, lines);
    }

    private static InputParameterBlock read(boolean forProject, Iterable<CsvLine> lines) {
        InputParameterBlock block = new InputParameterBlock(forProject);
        for (CsvLine line : lines) {
            if (line.first().equals("Project Input parameters") || line.first().equals("Database Input parameters")) continue;
            if (line.isEmpty()) break;
            InputParameterRow row = InputParameterRow.read(line);
            block.parameters.add(row);
        }
        return block;
    }

    @Override
    public void write(CsvBuffer buffer) {
        String header = this.forProject ? "Project Input parameters" : "Database Input parameters";
        buffer.putString(header).writeln().putRecords(this.parameters).writeln().putString("End").writeln().writeln();
    }
}

