/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.refdata;

import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvLine;
import org.openlca.simapro.csv.CsvRecord;
import org.openlca.simapro.csv.UncertaintyRecord;

public class InputParameterRow
implements CsvRecord {
    private String name;
    private double value;
    private UncertaintyRecord uncertainty;
    private boolean isHidden;
    private String comment;

    public String name() {
        return this.name;
    }

    public InputParameterRow name(String name) {
        this.name = name;
        return this;
    }

    public String comment() {
        return this.comment;
    }

    public InputParameterRow comment(String comment) {
        this.comment = comment;
        return this;
    }

    public UncertaintyRecord uncertainty() {
        return this.uncertainty;
    }

    public InputParameterRow uncertainty(UncertaintyRecord uncertainty) {
        this.uncertainty = uncertainty;
        return this;
    }

    public double value() {
        return this.value;
    }

    public InputParameterRow value(double value) {
        this.value = value;
        return this;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public InputParameterRow isHidden(boolean hidden) {
        this.isHidden = hidden;
        return this;
    }

    public static InputParameterRow read(CsvLine line) {
        return new InputParameterRow().name(line.getString(0)).value(line.getDouble(1)).uncertainty(UncertaintyRecord.read(line, 2)).isHidden(line.getBoolean(6)).comment(line.getString(7));
    }

    @Override
    public void write(CsvBuffer buffer) {
        buffer.putString(this.name).putDouble(this.value);
        UncertaintyRecord u = this.uncertainty != null ? this.uncertainty : UncertaintyRecord.undefined();
        u.write(buffer);
        buffer.putBoolean(this.isHidden).putString(this.comment).writeln();
    }
}

