/*
 * Decompiled with CFR 0.152.
 */
package org.openlca.simapro.csv.refdata;

import java.util.Iterator;
import java.util.function.Supplier;
import org.openlca.simapro.csv.CsvBlock;
import org.openlca.simapro.csv.CsvBuffer;
import org.openlca.simapro.csv.CsvLine;

public class SystemDescriptionBlock
implements CsvBlock {
    private String name;
    private String category;
    private String description;
    private String subSystems;
    private String cutOffRules;
    private String energyModel;
    private String transportModel;
    private String wasteModel;
    private String otherAssumptions;
    private String otherInformation;
    private String allocationRules;

    public String name() {
        return this.name;
    }

    public SystemDescriptionBlock name(String name) {
        this.name = name;
        return this;
    }

    public String category() {
        return this.category;
    }

    public SystemDescriptionBlock category(String category) {
        this.category = category;
        return this;
    }

    public String description() {
        return this.description;
    }

    public SystemDescriptionBlock description(String description) {
        this.description = description;
        return this;
    }

    public String subSystems() {
        return this.subSystems;
    }

    public SystemDescriptionBlock subSystems(String subSystems) {
        this.subSystems = subSystems;
        return this;
    }

    public String cutOffRules() {
        return this.cutOffRules;
    }

    public SystemDescriptionBlock cutOffRules(String cutOffRules) {
        this.cutOffRules = cutOffRules;
        return this;
    }

    public String energyModel() {
        return this.energyModel;
    }

    public SystemDescriptionBlock energyModel(String energyModel) {
        this.energyModel = energyModel;
        return this;
    }

    public String transportModel() {
        return this.transportModel;
    }

    public SystemDescriptionBlock transportModel(String transportModel) {
        this.transportModel = transportModel;
        return this;
    }

    public String wasteModel() {
        return this.wasteModel;
    }

    public SystemDescriptionBlock wasteModel(String wasteModel) {
        this.wasteModel = wasteModel;
        return this;
    }

    public String otherAssumptions() {
        return this.otherAssumptions;
    }

    public SystemDescriptionBlock otherAssumptions(String otherAssumptions) {
        this.otherAssumptions = otherAssumptions;
        return this;
    }

    public String otherInformation() {
        return this.otherInformation;
    }

    public SystemDescriptionBlock otherInformation(String otherInformation) {
        this.otherInformation = otherInformation;
        return this;
    }

    public String allocationRules() {
        return this.allocationRules;
    }

    public SystemDescriptionBlock allocationRules(String allocationRules) {
        this.allocationRules = allocationRules;
        return this;
    }

    public static SystemDescriptionBlock read(Iterable<CsvLine> lines) {
        SystemDescriptionBlock block = new SystemDescriptionBlock();
        Iterator<CsvLine> iter = lines.iterator();
        Supplier<String> nextFirst = () -> CsvLine.nextOf(iter).map(CsvLine::first).orElse("");
        while (iter.hasNext()) {
            CsvLine line = iter.next();
            if (line.isEmpty()) continue;
            String header = line.first();
            if (header.equalsIgnoreCase("End")) break;
            if (header.isEmpty()) continue;
            switch (header) {
                case "Name": {
                    block.name(nextFirst.get());
                    break;
                }
                case "Category": {
                    block.category(nextFirst.get());
                    break;
                }
                case "Description": {
                    block.description(nextFirst.get());
                    break;
                }
                case "Sub-systems": {
                    block.subSystems(nextFirst.get());
                    break;
                }
                case "Cut-off rules": {
                    block.cutOffRules(nextFirst.get());
                    break;
                }
                case "Energy model": {
                    block.energyModel(nextFirst.get());
                    break;
                }
                case "Transport model": {
                    block.transportModel(nextFirst.get());
                    break;
                }
                case "Waste model": {
                    block.wasteModel(nextFirst.get());
                    break;
                }
                case "Other assumptions": {
                    block.otherAssumptions(nextFirst.get());
                    break;
                }
                case "Other information": {
                    block.otherInformation(nextFirst.get());
                    break;
                }
                case "Allocation rules": {
                    block.allocationRules(nextFirst.get());
                }
            }
        }
        return block;
    }

    @Override
    public void write(CsvBuffer buffer) {
        buffer.putString("System description").writeln().writeln().putString("Name").writeln().putString(this.name).writeln().writeln().putString("Category").writeln().putString(this.category).writeln().writeln().putString("Description").writeln().putString(this.description).writeln().writeln().putString("Sub-systems").writeln().putString(this.subSystems).writeln().writeln().putString("Cut-off rules").writeln().putString(this.cutOffRules).writeln().writeln().putString("Energy model").writeln().putString(this.energyModel).writeln().writeln().putString("Transport model").writeln().putString(this.transportModel).writeln().writeln().putString("Waste model").writeln().putString(this.wasteModel).writeln().writeln().putString("Other assumptions").writeln().putString(this.otherAssumptions).writeln().writeln().putString("Other information").writeln().putString(this.otherInformation).writeln().writeln().putString("Allocation rules").writeln().putString(this.allocationRules).writeln().writeln().putString("End").writeln().writeln();
    }
}

