
package org.openmdx.system;

public class Version {

    /**
    * A specification version is compliant with a given one if<ol>
    * <li>its major numbers is equal to the given one
    * <li>its minor number is greater than or equal to the given one
    * </ol>
    */
    private final static String SPECIFICATION_VERSION = "2.17";
    
    /**
    * An implementation version is compliant with a given one if
    * their string representations are equal.
    */
    private final static String IMPLEMENTATION_VERSION = "2.17.8";

    /**
    * Get the specification version.
    *
    * @return the implementation version
    */
    public static String getSpecificationVersion(
    ){
        return Version.SPECIFICATION_VERSION;
    }

    /**
    * Get the implementation version.
    *
    * @return the implementation version
    */
    public static String getImplementationVersion(
    ){
        return Version.IMPLEMENTATION_VERSION;
    }
            
    /**
    * Define a main so that the version may easily be printed by a tool
    * 
    * @param arguments	the program arguments
    */
    public static void main(
        String arguments[]
    ) {
        System.out.println(
            new StringBuilder(
                Version.class.getName()
            ).append(
                '='
            ).append(
                Version.getImplementationVersion()
            )
        );
    }
    
}