/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.datalogger.ascii;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openmuc.framework.data.Record;
import org.openmuc.framework.datalogger.ascii.LogFileReader;
import org.openmuc.framework.datalogger.ascii.LogFileWriter;
import org.openmuc.framework.datalogger.ascii.LogIntervalContainerGroup;
import org.openmuc.framework.datalogger.ascii.utils.Const;
import org.openmuc.framework.datalogger.ascii.utils.LoggerUtils;
import org.openmuc.framework.datalogger.spi.DataLoggerService;
import org.openmuc.framework.datalogger.spi.LogChannel;
import org.openmuc.framework.datalogger.spi.LogRecordContainer;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AsciiLogger
implements DataLoggerService {
    private static final Logger logger = LoggerFactory.getLogger(AsciiLogger.class);
    private final String loggerDirectory;
    private final HashMap<String, LogChannel> logChannelList = new HashMap();
    private static HashMap<String, Long> lastLoggedLineList = new HashMap();
    private boolean isFillUpFiles = false;
    private static final String DIRECTORY = System.getProperty(AsciiLogger.class.getPackage().getName().toLowerCase() + ".directory");

    protected void activate(ComponentContext context) {
        logger.info("Activating Ascii Logger");
        this.setSystemProperties();
    }

    protected void deactivate(ComponentContext context) {
        logger.info("Deactivating Ascii Logger");
    }

    public AsciiLogger() {
        this.loggerDirectory = DIRECTORY == null ? Const.DEFAULT_DIRECTORY : DIRECTORY.trim();
        this.createDirectory(this.loggerDirectory);
    }

    public AsciiLogger(String loggerDirectory) {
        this.loggerDirectory = loggerDirectory;
        this.createDirectory(loggerDirectory);
    }

    private void createDirectory(String loggerDirectory) {
        logger.trace("using directory: " + loggerDirectory);
        File asciidata = new File(loggerDirectory);
        if (!asciidata.exists() && !asciidata.mkdirs()) {
            logger.error("Could not create logger directory: " + asciidata.getAbsolutePath());
        }
    }

    public String getId() {
        return "asciilogger";
    }

    public void setChannelsToLog(List<LogChannel> channels) {
        GregorianCalendar calendar = new GregorianCalendar(Locale.getDefault());
        this.logChannelList.clear();
        logger.trace("channels to log:");
        for (LogChannel channel : channels) {
            if (logger.isTraceEnabled()) {
                logger.trace("channel.getId() " + channel.getId());
                logger.trace("channel.getLoggingInterval() " + channel.getLoggingInterval());
            }
            this.logChannelList.put(channel.getId(), channel);
        }
        if (this.isFillUpFiles) {
            Map<String, Boolean> areHeaderIdentical = LoggerUtils.areHeadersIdentical(this.loggerDirectory, channels, calendar);
            for (Map.Entry<String, Boolean> entry : areHeaderIdentical.entrySet()) {
                String key = entry.getKey();
                boolean isHeaderIdentical = entry.getValue();
                if (isHeaderIdentical) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Fill file " + LoggerUtils.buildFilename(key, calendar) + " up with error flag 32.");
                    }
                    AsciiLogger.fillUpFileWithErrorCode(this.loggerDirectory, key, calendar);
                    continue;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Header not identical. Rename file " + LoggerUtils.buildFilename(key, calendar) + " to old.");
                }
                LoggerUtils.renameFileToOld(this.loggerDirectory, key, calendar);
            }
        } else {
            LoggerUtils.renameAllFilesToOld(this.loggerDirectory, calendar);
        }
    }

    public synchronized void log(List<LogRecordContainer> containers, long timestamp) {
        HashMap<List<Integer>, LogIntervalContainerGroup> logIntervalGroups = new HashMap<List<Integer>, LogIntervalContainerGroup>();
        for (LogRecordContainer container : containers) {
            LogIntervalContainerGroup group;
            int logInterval = -1;
            int logTimeOffset = 0;
            List<Integer> logTimeArray = Arrays.asList(logInterval, logTimeOffset);
            if (this.logChannelList.containsKey(container.getChannelId())) {
                logInterval = this.logChannelList.get(container.getChannelId()).getLoggingInterval();
                logTimeOffset = this.logChannelList.get(container.getChannelId()).getLoggingTimeOffset();
                logTimeArray = Arrays.asList(logInterval, logTimeOffset);
            }
            if (logIntervalGroups.containsKey(logTimeArray)) {
                group = (LogIntervalContainerGroup)logIntervalGroups.get(logTimeArray);
                group.add(container);
                continue;
            }
            group = new LogIntervalContainerGroup();
            group.add(container);
            logIntervalGroups.put(logTimeArray, group);
        }
        Iterator it = logIntervalGroups.entrySet().iterator();
        GregorianCalendar calendar = new GregorianCalendar(Locale.getDefault());
        while (it.hasNext()) {
            List logTimeArray = (List)it.next().getKey();
            LogIntervalContainerGroup group = (LogIntervalContainerGroup)logIntervalGroups.get(logTimeArray);
            LogFileWriter fileOutHandler = new LogFileWriter(this.loggerDirectory, this.isFillUpFiles);
            calendar.setTimeInMillis(timestamp);
            fileOutHandler.log(group, (Integer)logTimeArray.get(0), (Integer)logTimeArray.get(1), calendar, this.logChannelList);
            AsciiLogger.setLastLoggedLineTimeStamp((Integer)logTimeArray.get(0), (Integer)logTimeArray.get(1), calendar.getTimeInMillis());
        }
    }

    public List<Record> getRecords(String channelId, long startTime, long endTime) throws IOException {
        LogChannel logChannel = this.logChannelList.get(channelId);
        LogFileReader reader = null;
        if (logChannel != null) {
            reader = new LogFileReader(this.loggerDirectory, logChannel);
            return reader.getValues(startTime, endTime);
        }
        throw new IOException("ChannelID (" + channelId + ") not available. It's not a logging Channel.");
    }

    private void setSystemProperties() {
        String fillUpProperty = System.getProperty("org.openmuc.framework.datalogger.ascii.fillUpFiles");
        if (fillUpProperty != null) {
            this.isFillUpFiles = Boolean.parseBoolean(fillUpProperty);
        }
    }

    public static Long getLastLoggedLineTimeStamp(int loggingInterval, int loggingOffset) {
        return lastLoggedLineList.get(loggingInterval + "_" + loggingOffset);
    }

    public static void setLastLoggedLineTimeStamp(String loggerInterval_loggerTimeOffset, long lastTimestamp) {
        lastLoggedLineList.put(loggerInterval_loggerTimeOffset, lastTimestamp);
    }

    public static void setLastLoggedLineTimeStamp(int loggingInterval, int loggingOffset, long lastTimestamp) {
        lastLoggedLineList.put(loggingInterval + "_" + loggingOffset, lastTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long fillUpFileWithErrorCode(String directoryPath, String loggerInterval_loggerTimeOffset, Calendar calendar) {
        String filename = LoggerUtils.buildFilename(loggerInterval_loggerTimeOffset, calendar);
        File file = new File(directoryPath + filename);
        RandomAccessFile raf = LoggerUtils.getRandomAccessFile(file, "r");
        PrintWriter out = null;
        String firstLogLine = "";
        String lastLogLine = "";
        long loggingInterval = 0L;
        loggingInterval = loggerInterval_loggerTimeOffset.contains("_") ? Long.parseLong(loggerInterval_loggerTimeOffset.split("_")[0]) : Long.parseLong(loggerInterval_loggerTimeOffset);
        long lastLogLineTimeStamp = 0L;
        if (raf != null) {
            try {
                String line = raf.readLine();
                if (line != null) {
                    while (line.startsWith("#")) {
                        line = raf.readLine();
                    }
                    firstLogLine = raf.readLine();
                }
                byte[] readedByte = new byte[1];
                long filePosition = file.length() - 2L;
                while (lastLogLine.isEmpty() && filePosition > 0L) {
                    raf.seek(filePosition);
                    int readedBytes = raf.read(readedByte);
                    if (readedBytes == 1) {
                        String charString = new String(readedByte, "US-ASCII");
                        if (charString.equals("\n")) {
                            lastLogLine = raf.readLine();
                            continue;
                        }
                        --filePosition;
                        continue;
                    }
                    filePosition = -1L;
                }
                raf.close();
                int firstLogLineLength = firstLogLine.length();
                int lastLogLineLength = lastLogLine.length();
                if (firstLogLineLength != lastLogLineLength) {
                    LoggerUtils.renameFileToOld(directoryPath, loggerInterval_loggerTimeOffset, calendar);
                    logger.error("File is coruppted, could not fill up, renamed it. " + file.getAbsolutePath());
                    long l = 0L;
                    return l;
                }
                String[] lastLogLineArray = lastLogLine.split(";\t");
                StringBuilder errorValues = LoggerUtils.getErrorValues(lastLogLineArray);
                lastLogLineTimeStamp = (long)(Double.parseDouble(lastLogLineArray[2]) * 1000.0);
                out = LoggerUtils.getPrintWriter(file, true);
                long numberOfFillUpLines = LoggerUtils.getNumberOfFillUpLines(lastLogLineTimeStamp, loggingInterval);
                while (numberOfFillUpLines > 0L) {
                    lastLogLineTimeStamp = LoggerUtils.fillUp(out, lastLogLineTimeStamp, loggingInterval, lastLogLineLength, numberOfFillUpLines, errorValues);
                    numberOfFillUpLines = LoggerUtils.getNumberOfFillUpLines(lastLogLineTimeStamp, loggingInterval);
                }
                out.close();
                AsciiLogger.setLastLoggedLineTimeStamp(loggerInterval_loggerTimeOffset, lastLogLineTimeStamp);
            }
            catch (IOException e) {
                logger.error("Could not read file " + file.getAbsolutePath(), (Throwable)e);
                LoggerUtils.renameFileToOld(directoryPath, loggerInterval_loggerTimeOffset, calendar);
            }
            finally {
                try {
                    raf.close();
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    logger.error("Could not close file " + file.getAbsolutePath());
                }
            }
        }
        return lastLogLineTimeStamp;
    }
}

