/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.datalogger.ascii;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.openmuc.framework.data.ValueType;
import org.openmuc.framework.datalogger.ascii.LogIntervalContainerGroup;
import org.openmuc.framework.datalogger.spi.LogChannel;
import org.openmuc.framework.datalogger.spi.LogRecordContainer;

public class LogFileHeader {
    private LogFileHeader() {
    }

    public static String getIESDataFormatHeaderString(LogIntervalContainerGroup group, String filename, int loggingInterval, HashMap<String, LogChannel> logChannelList) {
        StringBuilder sb = new StringBuilder();
        LogFileHeader.setHeaderTop(sb, loggingInterval, filename);
        int colNumber = 4;
        for (LogRecordContainer container : group.getList()) {
            LogChannel logChannel = logChannelList.get(container.getChannelId());
            LogFileHeader.appendChannelSpecificComment(sb, logChannel, colNumber);
            ++colNumber;
        }
        List<LogRecordContainer> containers = group.getList();
        LogFileHeader.appendColumnHeaderTimestamp(sb);
        Iterator<LogRecordContainer> iterator = containers.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next().getChannelId());
            if (!iterator.hasNext()) continue;
            sb.append(";\t");
        }
        sb.append('\n');
        return sb.toString();
    }

    public static String getIESDataFormatHeaderString(String filename, List<LogChannel> logChannelList) {
        StringBuilder sb0 = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        LogFileHeader.setHeaderTop(sb0, logChannelList.get(0).getLoggingInterval(), filename);
        int colNumber = 4;
        ListIterator<LogChannel> iterator = logChannelList.listIterator();
        while (iterator.hasNext()) {
            LogChannel logChannel = (LogChannel)iterator.next();
            LogFileHeader.appendChannelSpecificComment(sb0, logChannel, colNumber);
            sb1.append(logChannel.getId());
            if (iterator.hasNext()) {
                sb1.append(";\t");
            }
            ++colNumber;
        }
        LogFileHeader.appendColumnHeaderTimestamp(sb0);
        sb0.append((CharSequence)sb1);
        sb0.append('\n');
        return sb0.toString();
    }

    private static void appendChannelSpecificComment(StringBuilder sb, LogChannel logChannel, int colNumber) {
        String description;
        String unit = logChannel.getUnit();
        if (unit.equals("")) {
            unit = "0";
        }
        ValueType vType = logChannel.getValueType();
        String valueType = vType.toString();
        int valueTypeLength = 0;
        if (vType.equals((Object)ValueType.BYTE_ARRAY) || vType.equals((Object)ValueType.STRING)) {
            valueTypeLength = logChannel.getValueTypeLength();
        }
        if ((description = logChannel.getDescription()).equals("")) {
            description = "-";
        }
        LogFileHeader.createRow(sb, String.format("%03d", colNumber), logChannel.getId(), "FALSE", "TRUE", unit, "other", valueType, valueTypeLength, description);
    }

    private static void appendColumnHeaderTimestamp(StringBuilder sb) {
        sb.append("YYYYMMDD");
        sb.append(";\t");
        sb.append("hhmmss");
        sb.append(";\t");
        sb.append("unixtimestamp");
        sb.append(";\t");
    }

    private static void setHeaderTop(StringBuilder sb, int loggingInterval, String filename) {
        String timestep_sec = String.valueOf((double)loggingInterval / 1000.0);
        String seperator = ";\t";
        LogFileHeader.appendStrings(sb, "#ies_format_version: ", String.valueOf(1.0), "\n");
        LogFileHeader.appendStrings(sb, "#file: ", filename, "\n");
        LogFileHeader.appendStrings(sb, "#file_info: ", "generated by AsciiLoger of OpenMUC", "\n");
        LogFileHeader.appendStrings(sb, "#timezone: ", LogFileHeader.getDiffLocalUTC(), "\n");
        LogFileHeader.appendStrings(sb, "#timestep_sec: ", timestep_sec, "\n");
        LogFileHeader.appendStrings(sb, "#", "col_no", seperator, "col_name", seperator, "confidential", seperator, "measured", seperator, "unit", seperator, "category", seperator, "comment", "\n");
        LogFileHeader.createRow(sb, "001", "YYYYMMDD", "FALSE", "FALSE", "0", "time", "INTEGER", 8, "Date [human readable]");
        LogFileHeader.createRow(sb, "002", "hhmmss", "FALSE", "FALSE", "0", "time", "SHORT", 6, "Time [human readable]");
        LogFileHeader.createRow(sb, "003", "unixtimestamp", "FALSE", "FALSE", "s", "time", "DOUBLE", 14, "lapsed seconds from 01-01-1970");
    }

    private static void createRow(StringBuilder sb, String col_no, String col_name, String confidential, String measured, String unit, String category, String valueType, int valueTypeLength, String comment) {
        String seperator = ";\t";
        String com_sign = "#";
        String vtEndSign = ". ";
        String vtSizeSep = ",";
        String valueTypeLengthString = "";
        if (valueTypeLength != 0) {
            valueTypeLengthString = valueTypeLengthString + valueTypeLength;
        }
        LogFileHeader.appendStrings(sb, com_sign, col_no, seperator, col_name, seperator, confidential, seperator, measured, seperator, unit, seperator, category, seperator, valueType, vtSizeSep, valueTypeLengthString, vtEndSign, comment, "\n");
    }

    private static void appendStrings(StringBuilder sb, String ... s) {
        for (String element : s) {
            sb.append(element);
        }
    }

    private static String getDiffLocalUTC() {
        long time = 0L;
        GregorianCalendar calendar = new GregorianCalendar(Locale.getDefault());
        time = ((Calendar)calendar).getTimeZone().getRawOffset();
        String ret = (time /= 3600000L) >= 0L ? "+ " + time : "- " + time;
        return ret;
    }
}

