/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.datalogger.ascii;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.openmuc.framework.data.ByteArrayValue;
import org.openmuc.framework.data.DoubleValue;
import org.openmuc.framework.data.Flag;
import org.openmuc.framework.data.Record;
import org.openmuc.framework.data.StringValue;
import org.openmuc.framework.data.Value;
import org.openmuc.framework.datalogger.ascii.utils.LoggerUtils;
import org.openmuc.framework.datalogger.spi.LogChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileReader {
    private static final Logger logger = LoggerFactory.getLogger(LogFileReader.class);
    private final String channelId;
    private final String path;
    private final int loggingInterval;
    private final int logTimeOffset;
    private int unixTimestampColumn;
    private long startTimestamp;
    private long endTimestamp;
    private long firstTimestampFromFile;

    public LogFileReader(String path, LogChannel logChannel) {
        this.path = path;
        this.channelId = logChannel.getId();
        this.loggingInterval = logChannel.getLoggingInterval();
        this.logTimeOffset = logChannel.getLoggingTimeOffset();
        this.firstTimestampFromFile = -1L;
    }

    public List<Record> getValues(long startTimestamp, long endTimestamp) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        ArrayList<Record> allRecords = new ArrayList<Record>();
        List<String> filenames = LoggerUtils.getFilenames(this.loggingInterval, this.logTimeOffset, this.startTimestamp, this.endTimestamp);
        for (int i = 0; i < filenames.size(); ++i) {
            List<Record> fileRecords;
            Boolean nextFile = false;
            if (logger.isTraceEnabled()) {
                logger.trace("using " + filenames.get(i));
            }
            String filepath = this.path.endsWith(File.separator) ? this.path + filenames.get(i) : this.path + File.separatorChar + filenames.get(i);
            if (i > 0) {
                nextFile = true;
            }
            if ((fileRecords = this.processFile(filepath, nextFile)) == null) continue;
            allRecords.addAll(fileRecords);
            if (!logger.isTraceEnabled()) continue;
            logger.trace("read records: " + fileRecords.size());
        }
        return allRecords;
    }

    public Record getValue(long timestamp) {
        Record record = null;
        List<Record> records = this.getValues(timestamp, timestamp);
        if (records.size() == 0) {
            record = null;
        } else if (records.size() == 1) {
            record = records.get(0);
        } else if (records.size() == 2) {
            record = records.get(0);
        }
        return record;
    }

    private List<Record> processFile(String filepath, Boolean nextFile) {
        ArrayList<Record> records = new ArrayList<Record>();
        String line = null;
        long currentPosition = 0L;
        long firstTimestamp = 0L;
        String firstValueLine = null;
        long currentTimestamp = 0L;
        RandomAccessFile raf = LoggerUtils.getRandomAccessFile(new File(filepath), "r");
        if (raf == null) {
            return null;
        }
        try {
            int channelColumn = -1;
            while (channelColumn <= 0) {
                line = raf.readLine();
                channelColumn = LoggerUtils.getColumnNumberByName(line, this.channelId);
                this.unixTimestampColumn = LoggerUtils.getColumnNumberByName(line, "unixtimestamp");
            }
            firstValueLine = raf.readLine();
            long rowSize = firstValueLine.length() + 1;
            currentPosition = raf.getFilePointer() - rowSize;
            firstTimestamp = (long)(Double.valueOf(firstValueLine.split(";\t")[this.unixTimestampColumn]) * 1000.0);
            if (nextFile.booleanValue() || this.startTimestamp < firstTimestamp) {
                this.startTimestamp = firstTimestamp;
            }
            if (this.startTimestamp >= firstTimestamp) {
                long filepos = this.getFilePosition(this.loggingInterval, this.startTimestamp, firstTimestamp, currentPosition, rowSize);
                raf.seek(filepos);
                for (currentTimestamp = this.startTimestamp; (line = raf.readLine()) != null && currentTimestamp <= this.endTimestamp; currentTimestamp += (long)this.loggingInterval) {
                    this.processLine(line, channelColumn, records);
                }
                raf.close();
            } else {
                records = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            records = null;
        }
        return records;
    }

    private void processLine(String line, int channelColumn, List<Record> records) {
        if (!line.startsWith("#")) {
            this.readRecordFromLine(line, channelColumn, records);
        }
    }

    private void readRecordFromLine(String line, int channelColumn, List<Record> records) {
        String[] columnValue = line.split(";\t");
        try {
            Double timestampS = Double.parseDouble(columnValue[this.unixTimestampColumn]);
            long timestampMS = Double.valueOf(timestampS * 1000.0).longValue();
            if (this.isTimestampPartOfRequestedInterval(timestampMS)) {
                Record record = this.convertLogfileEntryToRecord(columnValue[channelColumn].trim(), timestampMS);
                records.add(record);
            }
        }
        catch (NumberFormatException e) {
            logger.debug("It's not a timestamp.");
            e.printStackTrace();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
    }

    private boolean isTimestampPartOfRequestedInterval(long lineTimestamp) {
        boolean result = false;
        if (this.firstTimestampFromFile == -1L) {
            this.firstTimestampFromFile = lineTimestamp;
        }
        if (lineTimestamp >= this.startTimestamp && lineTimestamp <= this.endTimestamp) {
            result = true;
        }
        return result;
    }

    private long getFilePosition(int loggingInterval, long startTimestamp, long firstTimestampOfFile, long firstValuePos, long rowSize) {
        long timeOffsetMs = startTimestamp - firstTimestampOfFile;
        long numberOfLinesToSkip = timeOffsetMs / (long)loggingInterval;
        if (timeOffsetMs % (long)loggingInterval != 0L) {
            ++numberOfLinesToSkip;
        }
        long pos = numberOfLinesToSkip * rowSize + firstValuePos;
        return pos;
    }

    private Record convertLogfileEntryToRecord(String strValue, long timestamp) {
        Record record = null;
        record = this.isNumber(strValue) ? new Record((Value)new DoubleValue(Double.parseDouble(strValue)), Long.valueOf(timestamp), Flag.VALID) : this.getRecordFromNonNumberValue(strValue, timestamp);
        return record;
    }

    private Record getRecordFromNonNumberValue(String strValue, long timestamp) {
        Record record = null;
        if (strValue.trim().startsWith("err")) {
            int errorSize = "err".length();
            int stringLength = strValue.length();
            String errorFlag = strValue.substring(errorSize, errorSize + stringLength - errorSize);
            record = this.isNumber(errorFlag = errorFlag.trim()) ? new Record(null, Long.valueOf(timestamp), Flag.newFlag((int)Integer.parseInt(errorFlag))) : new Record(null, Long.valueOf(timestamp), Flag.NO_VALUE_RECEIVED_YET);
        } else if (strValue.trim().startsWith("0x")) {
            try {
                record = new Record((Value)new ByteArrayValue(strValue.trim().getBytes("US-ASCII")), Long.valueOf(timestamp), Flag.VALID);
            }
            catch (UnsupportedEncodingException e) {
                record = new Record(Flag.UNKNOWN_ERROR);
                logger.error("Hexadecimal value is non US-ASCII decoded, value is: " + strValue.trim());
            }
        } else {
            record = new Record((Value)new StringValue(strValue.trim()), Long.valueOf(timestamp), Flag.VALID);
        }
        return record;
    }

    private boolean isNumber(String strValue) {
        boolean isDecimalSeparatorFound = false;
        if (!Character.isDigit(strValue.charAt(0)) && strValue.charAt(0) != '-' && strValue.charAt(0) != '+') {
            return false;
        }
        for (char charactor : strValue.substring(1).toCharArray()) {
            if (Character.isDigit(charactor)) continue;
            if (charactor == '.' && !isDecimalSeparatorFound) {
                isDecimalSeparatorFound = true;
                continue;
            }
            return false;
        }
        return true;
    }
}

