/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.datalogger.ascii;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.openmuc.framework.data.Flag;
import org.openmuc.framework.data.Record;
import org.openmuc.framework.data.Value;
import org.openmuc.framework.data.ValueType;
import org.openmuc.framework.datalogger.ascii.AsciiLogger;
import org.openmuc.framework.datalogger.ascii.LogFileHeader;
import org.openmuc.framework.datalogger.ascii.LogIntervalContainerGroup;
import org.openmuc.framework.datalogger.ascii.exceptions.WrongCharacterException;
import org.openmuc.framework.datalogger.ascii.exceptions.WrongScalingException;
import org.openmuc.framework.datalogger.ascii.utils.IESDataFormatUtils;
import org.openmuc.framework.datalogger.ascii.utils.LogRecordContainerAscii;
import org.openmuc.framework.datalogger.ascii.utils.LoggerUtils;
import org.openmuc.framework.datalogger.spi.LogChannel;
import org.openmuc.framework.datalogger.spi.LogRecordContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileWriter {
    private final String directoryPath;
    private static final Logger logger = LoggerFactory.getLogger(LogFileWriter.class);
    private File actualFile;
    private final boolean isFillUpFiles;

    public LogFileWriter(String directoryPath, boolean isFillUpFiles) {
        this.isFillUpFiles = isFillUpFiles;
        this.directoryPath = directoryPath;
    }

    public void log(LogIntervalContainerGroup group, int loggingInterval, int logTimeOffset, Calendar calendar, HashMap<String, LogChannel> logChannelList) {
        PrintStream out = this.getStream(group, loggingInterval, logTimeOffset, calendar, logChannelList);
        if (out == null) {
            return;
        }
        List<LogRecordContainer> logRecordContainer = group.getList();
        if (this.isFillUpFiles) {
            this.fillUpFile(loggingInterval, logTimeOffset, calendar, logChannelList, logRecordContainer, out);
        }
        String logLine = this.getLoggingLine(logRecordContainer, logChannelList, calendar, false);
        out.print(logLine);
        out.flush();
        out.close();
    }

    private void fillUpFile(int loggingInterval, int logTimeOffset, Calendar calendar, HashMap<String, LogChannel> logChannelList, List<LogRecordContainer> logRecordContainer, PrintStream out) {
        long diff;
        Long lastLoglineTimestamp = AsciiLogger.getLastLoggedLineTimeStamp(loggingInterval, logTimeOffset);
        if (lastLoglineTimestamp != null && lastLoglineTimestamp > 0L && (diff = calendar.getTimeInMillis() - lastLoglineTimestamp) >= (long)loggingInterval) {
            GregorianCalendar errCalendar = new GregorianCalendar(Locale.getDefault());
            errCalendar.setTimeInMillis(lastLoglineTimestamp);
            if (errCalendar.get(6) == calendar.get(6) && errCalendar.get(1) == calendar.get(1)) {
                long numOfErrorLines = diff / (long)loggingInterval;
                int i = 1;
                while ((long)i < numOfErrorLines) {
                    errCalendar.setTimeInMillis(lastLoglineTimestamp + (long)loggingInterval * (long)i);
                    out.print(this.getLoggingLine(logRecordContainer, logChannelList, errCalendar, true));
                    ++i;
                }
            }
        }
    }

    private String getLoggingLine(List<LogRecordContainer> logRecordContainer, HashMap<String, LogChannel> logChannelList, Calendar calendar, boolean isError32) {
        StringBuilder sb = new StringBuilder();
        LoggerUtils.setLoggerTimestamps(sb, calendar);
        for (int i = 0; i < logRecordContainer.size(); ++i) {
            boolean left;
            int size;
            String value;
            block25: {
                LogChannel logChannel;
                block21: {
                    Record recordBackup;
                    String channelID;
                    block24: {
                        Record record;
                        block22: {
                            Value recordValue;
                            block23: {
                                value = "";
                                size = 6;
                                left = true;
                                record = logRecordContainer.get(i).getRecord();
                                channelID = logRecordContainer.get(i).getChannelId();
                                logChannel = logChannelList.get(channelID);
                                if (record == null) break block21;
                                recordValue = record.getValue();
                                recordBackup = null;
                                if (isError32) {
                                    recordBackup = logRecordContainer.get(i).getRecord();
                                    logRecordContainer.set(i, new LogRecordContainerAscii(channelID, new Record(Flag.DATA_LOGGING_NOT_ACTIVE)));
                                }
                                if ((record = logRecordContainer.get(i).getRecord()).getFlag() != Flag.VALID) break block22;
                                if (recordValue != null) break block23;
                                value = LoggerUtils.buildError(Flag.CANNOT_WRITE_NULL_VALUE);
                                size = this.getDataTypeSize(logChannel, i);
                                break block24;
                            }
                            ValueType valueType = logChannel.getValueType();
                            switch (valueType) {
                                case BOOLEAN: {
                                    value = String.valueOf(recordValue.asShort());
                                    break;
                                }
                                case LONG: {
                                    value = String.valueOf(recordValue.asLong());
                                    size = 21;
                                    break;
                                }
                                case INTEGER: {
                                    value = String.valueOf(recordValue.asInt());
                                    size = 12;
                                    break;
                                }
                                case SHORT: {
                                    value = String.valueOf(recordValue.asShort());
                                    size = 7;
                                    break;
                                }
                                case DOUBLE: 
                                case FLOAT: {
                                    size = 9;
                                    try {
                                        value = IESDataFormatUtils.convertDoubleToStringWithMaxLength(recordValue.asDouble(), size);
                                    }
                                    catch (WrongScalingException e) {
                                        value = LoggerUtils.buildError(Flag.UNKNOWN_ERROR);
                                        logger.error(e.getMessage() + " ChannelId: " + channelID);
                                    }
                                    break;
                                }
                                case BYTE_ARRAY: {
                                    left = false;
                                    size = this.checkMinimalValueSize(this.getDataTypeSize(logChannel, i));
                                    byte[] byteArray = recordValue.asByteArray();
                                    if (byteArray.length > size) {
                                        value = LoggerUtils.buildError(Flag.UNKNOWN_ERROR);
                                        logger.error("The byte array is too big, length is " + byteArray.length + " but max. length allowed is " + size + ", ChannelId: " + channelID);
                                        break;
                                    }
                                    value = "0x" + LoggerUtils.byteArrayToHexString(byteArray);
                                    break;
                                }
                                case STRING: {
                                    left = false;
                                    size = this.checkMinimalValueSize(this.getDataTypeSize(logChannel, i));
                                    value = recordValue.toString();
                                    int valueLength = value.length();
                                    try {
                                        this.checkStringValue(value);
                                    }
                                    catch (WrongCharacterException e) {
                                        value = LoggerUtils.buildError(Flag.UNKNOWN_ERROR);
                                        logger.error(e.getMessage());
                                    }
                                    if (valueLength > size) {
                                        value = LoggerUtils.buildError(Flag.UNKNOWN_ERROR);
                                        logger.error("The string is too big, length is " + valueLength + " but max. length allowed is " + size + ", ChannelId: " + channelID);
                                        break;
                                    }
                                    break block24;
                                }
                                case BYTE: {
                                    value = String.format("0x%02x", recordValue.asByte());
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("unsupported valueType");
                                }
                            }
                            break block24;
                        }
                        value = LoggerUtils.buildError(record.getFlag());
                        size = this.checkMinimalValueSize(this.getDataTypeSize(logChannel, i));
                    }
                    if (isError32) {
                        logRecordContainer.set(i, new LogRecordContainerAscii(channelID, recordBackup));
                    }
                    break block25;
                }
                value = LoggerUtils.buildError(Flag.UNKNOWN_ERROR);
                size = this.checkMinimalValueSize(this.getDataTypeSize(logChannel, i));
            }
            if (left) {
                LoggerUtils.addSpaces(value, size, sb);
                sb.append(value);
            } else {
                sb.append(value);
                LoggerUtils.addSpaces(value, size, sb);
            }
            if (!LoggerUtils.hasNext(logRecordContainer, i)) continue;
            sb.append(";\t");
        }
        sb.append('\n');
        return sb.toString();
    }

    private void checkStringValue(String value) throws WrongCharacterException {
        if (value.contains(";\t")) {
            throw new WrongCharacterException("Wrong character: String contains Seperator character: ;\t");
        }
        if (value.startsWith("err")) {
            throw new WrongCharacterException("Wrong character: String begins with: err");
        }
        if (value.startsWith("0x")) {
            throw new WrongCharacterException("Wrong character: String begins with: 0x");
        }
        if (!value.matches("^[\\x00-\\x7F]*")) {
            throw new WrongCharacterException("Wrong character: Non ASCII character in String.");
        }
    }

    private int checkMinimalValueSize(int size) {
        if (size < 6) {
            size = 6;
        }
        return size;
    }

    private PrintStream getStream(LogIntervalContainerGroup group, int loggingInterval, int logTimeOffset, Calendar calendar, HashMap<String, LogChannel> logChannelList) {
        File file;
        String filename = LoggerUtils.buildFilename(loggingInterval, logTimeOffset, calendar);
        this.actualFile = file = new File(this.directoryPath + filename);
        PrintStream out = null;
        try {
            if (file.exists()) {
                out = new PrintStream((OutputStream)new FileOutputStream(file, true), false, "US-ASCII");
            } else {
                out = new PrintStream((OutputStream)new FileOutputStream(file, true), false, "US-ASCII");
                String headerString = LogFileHeader.getIESDataFormatHeaderString(group, file.getName(), loggingInterval, logChannelList);
                out.print(headerString);
                out.flush();
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return out;
    }

    private int getDataTypeSize(LogChannel logChannel, int iterator) {
        int size = 6;
        if (logChannel != null) {
            boolean isByteArray = logChannel.getValueType().equals((Object)ValueType.BYTE_ARRAY);
            boolean isString = logChannel.getValueType().equals((Object)ValueType.STRING);
            size = isString ? logChannel.getValueTypeLength() : (isByteArray ? "0x".length() + logChannel.getValueTypeLength() * 2 : LoggerUtils.getLengthOfValueType(logChannel.getValueType()));
        } else {
            ValueType vt = LoggerUtils.identifyValueType(iterator + 3 + 1, this.actualFile);
            size = LoggerUtils.getLengthOfValueType(vt);
            if ((vt.equals((Object)ValueType.BYTE_ARRAY) || vt.equals((Object)ValueType.STRING)) && size <= 6) {
                size = LoggerUtils.getValueTypeLengthFromFile(iterator + 3 + 1, this.actualFile);
            }
        }
        return size;
    }
}

