/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.datalogger.ascii.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.openmuc.framework.datalogger.ascii.exceptions.WrongScalingException;

public class IESDataFormatUtils {
    public static String convertDoubleToStringWithMaxLength(double value, int maxLength) throws WrongScalingException {
        String format;
        double valueWork = value;
        long lValue = (long)(valueWork * 10000.0);
        valueWork = (double)lValue / 10000.0;
        if (lValue >= 0L) {
            if (lValue >> 63 != 0L) {
                valueWork *= -1.0;
            }
            format = '+' + IESDataFormatUtils.getFormat(valueWork);
        } else {
            format = IESDataFormatUtils.getFormat(valueWork);
        }
        DecimalFormat df = new DecimalFormat(format, new DecimalFormatSymbols(Locale.ENGLISH));
        String ret = df.format(valueWork);
        if (ret.length() > maxLength) {
            throw new WrongScalingException("Double value (" + value + ") too large for convertion into max length " + maxLength + "! Try to scale value.");
        }
        return ret;
    }

    private static String getFormat(double value) {
        long lValue = (long)value;
        String format = lValue > 999999L || lValue < -999999L ? "#######0" : (lValue > 99999L || lValue < -99999L ? "#####0.0" : (lValue > 9999L || lValue < -9999L ? "####0.00" : "###0.000"));
        return format;
    }
}

