/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.datalogger.ascii.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.openmuc.framework.data.Flag;
import org.openmuc.framework.data.ValueType;
import org.openmuc.framework.datalogger.ascii.LogFileHeader;
import org.openmuc.framework.datalogger.spi.LogChannel;
import org.openmuc.framework.datalogger.spi.LogRecordContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggerUtils.class);

    public static List<String> getFilenames(int loggingInterval, int logTimeOffset, long startTimestamp, long endTimestamp) {
        GregorianCalendar calendarStart = new GregorianCalendar(Locale.getDefault());
        calendarStart.setTimeInMillis(startTimestamp);
        GregorianCalendar calendarEnd = new GregorianCalendar(Locale.getDefault());
        calendarEnd.setTimeInMillis(endTimestamp);
        ArrayList<String> filenames = new ArrayList<String>();
        while (calendarStart.before(calendarEnd) || ((Calendar)calendarStart).equals(calendarEnd)) {
            String filename = LoggerUtils.buildFilename(loggingInterval, logTimeOffset, calendarStart);
            filenames.add(filename);
            ((Calendar)calendarStart).add(5, 1);
            calendarStart.set(11, 0);
            calendarStart.set(12, 0);
            calendarStart.set(13, 0);
            calendarStart.set(14, 0);
        }
        return filenames;
    }

    public static String getFilename(int loggingInterval, int logTimeOffset, long timestamp) {
        GregorianCalendar calendar = new GregorianCalendar(Locale.getDefault());
        calendar.setTimeInMillis(timestamp);
        return LoggerUtils.buildFilename(loggingInterval, logTimeOffset, calendar);
    }

    public static String buildFilename(int loggingInterval, int logTimeOffset, Calendar calendar) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%1$tY%1$tm%1$td", calendar));
        sb.append('_');
        sb.append(String.valueOf(loggingInterval));
        if (logTimeOffset != 0) {
            sb.append('_');
            sb.append(logTimeOffset);
        }
        sb.append(".dat");
        return sb.toString();
    }

    public static String buildFilename(String interval_timeOffset, Calendar calendar) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%1$tY%1$tm%1$td", calendar));
        sb.append('_');
        sb.append(interval_timeOffset);
        sb.append(".dat");
        return sb.toString();
    }

    public static boolean hasNext(List<LogRecordContainer> containers, int i) {
        boolean result = false;
        if (i <= containers.size() - 2) {
            result = true;
        }
        return result;
    }

    public static void renameAllFilesToOld(String directoryPath, Calendar calendar) {
        String date = String.format("%1$tY%1$tm%1$td", calendar);
        File dir = new File(directoryPath);
        File[] files = dir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                String currentName = file.getName();
                if (!currentName.startsWith(date) || !currentName.endsWith(".dat")) continue;
                String newName = currentName.substring(0, currentName.length() - ".dat".length());
                newName = newName + ".old";
                int j = 0;
                File fileWithNewName = new File(directoryPath + newName + j);
                while (fileWithNewName.exists()) {
                    fileWithNewName = new File(directoryPath + newName + ++j);
                }
                if (file.renameTo(fileWithNewName)) continue;
                logger.error("Could not rename file to " + newName);
            }
        } else {
            logger.error("No file found in " + directoryPath);
        }
    }

    public static void renameFileToOld(String directoryPath, String loggerInterval_loggerTimeOffset, Calendar calendar) {
        File file = new File(directoryPath + LoggerUtils.buildFilename(loggerInterval_loggerTimeOffset, calendar));
        if (file.exists()) {
            String currentName = file.getName();
            String newName = currentName.substring(0, currentName.length() - ".dat".length());
            newName = newName + ".old";
            int j = 0;
            File fileWithNewName = new File(directoryPath + newName + j);
            while (fileWithNewName.exists()) {
                fileWithNewName = new File(directoryPath + newName + ++j);
            }
            if (!file.renameTo(fileWithNewName)) {
                logger.error("Could not rename file to " + newName);
            }
        }
    }

    public static Calendar getCalendarTodayZero(Calendar today) {
        GregorianCalendar calendarZero = new GregorianCalendar(Locale.getDefault());
        calendarZero.set(today.get(1), today.get(2), today.get(5), 0, 0, 0);
        calendarZero.set(14, 0);
        return calendarZero;
    }

    public static void addSpaces(String value, int size, StringBuilder sb) {
        for (int i = value.length(); i < size; ++i) {
            sb.append(' ');
        }
    }

    public static void appendSpaces(StringBuilder sb, int number) {
        for (int i = 0; i < number; ++i) {
            sb.append(' ');
        }
    }

    public static String buildError(Flag flag) {
        return "err" + flag.getCode();
    }

    public static int getColumnNumberByName(String line, String name) {
        int channelColumn = -1;
        if (!line.startsWith("#")) {
            String[] columns = line.split(";\t");
            for (int i = 0; i < columns.length; ++i) {
                if (!name.equals(columns[i])) continue;
                return i;
            }
        }
        return channelColumn;
    }

    public static int getCommentColumnNumberByName(String name, BufferedReader br) throws IOException, NullPointerException {
        String line = br.readLine();
        while (line != null && line.startsWith("#")) {
            if (line.contains(name)) {
                String[] columns = line.split(";\t");
                for (int i = 0; i < columns.length; ++i) {
                    if (!name.equals(columns[i])) continue;
                    return i;
                }
            }
            try {
                line = br.readLine();
            }
            catch (NullPointerException e) {
                return -1;
            }
        }
        return -1;
    }

    public static String getCommentValue(int col_no, int column, BufferedReader br) throws IOException {
        String line = br.readLine();
        String columnName = String.format("%03d", col_no);
        while (line != null && line.startsWith("#")) {
            if (line.startsWith("#" + columnName)) {
                String[] columns = line.split(";\t");
                return columns[column];
            }
            line = br.readLine();
        }
        return null;
    }

    public static ValueType identifyValueType(int columnNumber, File dataFile) {
        String valueTypeWithSize = LoggerUtils.getValueTypeAsString(columnNumber, dataFile);
        String[] valueTypeWithSizeArray = valueTypeWithSize.split(". ");
        String valueType = valueTypeWithSizeArray[0].split(",")[0];
        return ValueType.valueOf((String)valueType);
    }

    public static int getValueTypeLengthFromFile(int columnNumber, File dataFile) {
        String valueType = LoggerUtils.getValueTypeAsString(columnNumber, dataFile);
        return LoggerUtils.getByteStringLength(valueType);
    }

    /*
     * Exception decompiling
     */
    private static String getValueTypeAsString(int columnNumber, File dataFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int getLengthOfValueType(ValueType valueType) {
        int size;
        switch (valueType) {
            case DOUBLE: {
                size = 9;
                break;
            }
            case FLOAT: {
                size = 9;
                break;
            }
            case INTEGER: {
                size = 12;
                break;
            }
            case LONG: {
                size = 21;
                break;
            }
            case SHORT: {
                size = 7;
                break;
            }
            case BYTE_ARRAY: {
                size = 6;
                break;
            }
            case STRING: {
                size = 6;
                break;
            }
            default: {
                size = 6;
            }
        }
        return size;
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        for (int j = 0; j < byteArray.length; ++j) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static void setLoggerTimestamps(StringBuilder sb, Calendar calendar) {
        double unixtimestamp_sec = (double)calendar.getTimeInMillis() / 1000.0;
        sb.append(String.format("%1$tY%1$tm%1$td", calendar));
        sb.append(";\t");
        sb.append(String.format("%1$tH%1$tM%1$tS", calendar));
        sb.append(";\t");
        sb.append(String.format(Locale.ENGLISH, "%10.3f", unixtimestamp_sec));
        sb.append(";\t");
    }

    public static void setLoggerTimestamps(StringBuilder sb, long unixTimeStamp) {
        GregorianCalendar calendar = new GregorianCalendar(Locale.getDefault());
        calendar.setTimeInMillis(unixTimeStamp);
        double unixtimestamp_sec = (double)unixTimeStamp / 1000.0;
        sb.append(String.format("%1$tY%1$tm%1$td", calendar));
        sb.append(";\t");
        sb.append(String.format("%1$tH%1$tM%1$tS", calendar));
        sb.append(";\t");
        sb.append(String.format(Locale.ENGLISH, "%10.3f", unixtimestamp_sec));
        sb.append(";\t");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHeaderFromFile(String filePath, String logInterval_logTimeOffset) {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), "US-ASCII"));
        }
        catch (IOException e1) {
            return "";
        }
        if (br != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line = br.readLine();
                if (line != null) {
                    sb.append(line);
                    while (line != null && line.startsWith("#")) {
                        sb.append('\n');
                        line = br.readLine();
                        sb.append(line);
                    }
                }
            }
            catch (IOException e) {
                logger.error("Problems to handle file: " + filePath, (Throwable)e);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error("Cannot close file: " + filePath, (Throwable)e);
                }
            }
            return sb.toString();
        }
        return "";
    }

    public static RandomAccessFile getRandomAccessFile(File file, String accesMode) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, accesMode);
        }
        catch (FileNotFoundException e) {
            logger.warn("Requested logfile: '" + file.getAbsolutePath() + "' not found.");
        }
        return raf;
    }

    public static PrintWriter getPrintWriter(File file, boolean append) throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "US-ASCII"));
        }
        catch (IOException e) {
            logger.error("Cannot open file: " + file.getAbsolutePath());
            throw new IOException(e);
        }
        return writer;
    }

    public static Map<String, Boolean> areHeadersIdentical(String loggerDirectory, List<LogChannel> channels, Calendar calendar) {
        TreeMap<String, Boolean> areHeadersIdentical = new TreeMap<String, Boolean>();
        TreeMap logChannelMap = new TreeMap();
        String key = "";
        for (LogChannel logChannel : channels) {
            key = logChannel.getLoggingTimeOffset() != 0 ? logChannel.getLoggingInterval() + "_" + logChannel.getLoggingTimeOffset() : logChannel.getLoggingInterval().toString();
            if (!logChannelMap.containsKey(key)) {
                ArrayList<LogChannel> logChannelList = new ArrayList<LogChannel>();
                logChannelList.add(logChannel);
                logChannelMap.put(key, logChannelList);
                continue;
            }
            ((List)logChannelMap.get(key)).add(logChannel);
        }
        for (Map.Entry entry : logChannelMap.entrySet()) {
            key = (String)entry.getKey();
            List logChannels = (List)entry.getValue();
            String fileName = LoggerUtils.buildFilename(key, calendar);
            String headerGenerated = LogFileHeader.getIESDataFormatHeaderString(fileName, logChannels);
            String oldHeader = LoggerUtils.getHeaderFromFile(loggerDirectory + fileName, key) + '\n';
            boolean isHeaderIdentical = headerGenerated.equals(oldHeader);
            areHeadersIdentical.put(key, isHeaderIdentical);
        }
        return areHeadersIdentical;
    }

    public static long fillUp(PrintWriter out, long unixTimeStamp, long loggingInterval, int lastLogLineLength, long numberOfFillUpLines, StringBuilder errorValues) throws IOException {
        StringBuilder line = new StringBuilder();
        int i = 0;
        while ((long)i < numberOfFillUpLines) {
            line.setLength(0);
            LoggerUtils.setLoggerTimestamps(line, unixTimeStamp += loggingInterval);
            line.append((CharSequence)errorValues);
            line.append('\n');
            out.append(line.toString());
            ++i;
        }
        return unixTimeStamp;
    }

    public static long getNumberOfFillUpLines(long lastUnixTimeStamp, long loggingInterval) {
        long numberOfFillUpLines = 0L;
        long currentUnixTimeStamp = System.currentTimeMillis();
        numberOfFillUpLines = (currentUnixTimeStamp - lastUnixTimeStamp) / loggingInterval;
        return numberOfFillUpLines;
    }

    public static StringBuilder getErrorValues(String[] lineArray) {
        StringBuilder errorValues = new StringBuilder();
        int arrayLength = lineArray.length;
        int errorCodeLength = "err".length() + 2;
        int separatorLength = ";\t".length();
        int length = 0;
        for (int i = 3; i < arrayLength; ++i) {
            length = lineArray[i].length();
            length -= errorCodeLength;
            if (i > arrayLength - 1) {
                length -= separatorLength;
            }
            LoggerUtils.appendSpaces(errorValues, length);
            errorValues.append("err");
            errorValues.append(Flag.DATA_LOGGING_NOT_ACTIVE.getCode());
            if (i >= arrayLength - 1) continue;
            errorValues.append(";\t");
        }
        return errorValues;
    }

    private static int getByteStringLength(String string) {
        int size;
        String[] stringArray = string.split(",");
        try {
            size = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException e) {
            logger.warn("Not able to get ValueType length from String. Set length to minimal lenght 6.");
            size = 6;
        }
        return size;
    }

    private static void closeBufferdReader(BufferedReader br) {
        try {
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

