/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.amqp;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.openmuc.framework.lib.amqp.AmqpBufferMessageIterator;
import org.openmuc.framework.lib.amqp.AmqpMessageTuple;
import org.openmuc.framework.lib.filePersistence.FilePersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpBufferHandler {
    private static final Logger logger = LoggerFactory.getLogger(AmqpBufferHandler.class);
    private final Queue<AmqpMessageTuple> buffer = new LinkedList<AmqpMessageTuple>();
    private final long maxBufferSizeBytes;
    private final int maxFileCount;
    private final FilePersistence filePersistence;
    private long currentBufferSize = 0L;

    public AmqpBufferHandler(long maxBufferSize, int maxFileCount, long maxFileSize, String persistenceDir) {
        this.maxBufferSizeBytes = maxBufferSize * 1024L;
        this.maxFileCount = maxFileCount;
        this.filePersistence = this.isFileBufferEnabled() ? new FilePersistence(persistenceDir, maxFileCount, maxFileSize) : null;
    }

    private boolean isFileBufferEnabled() {
        return this.maxFileCount > 0 && this.maxBufferSizeBytes > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String routingKey, byte[] message) {
        if (this.isBufferTooFull(message)) {
            this.handleFull(routingKey, message);
        } else {
            Queue<AmqpMessageTuple> queue = this.buffer;
            synchronized (queue) {
                this.buffer.add(new AmqpMessageTuple(routingKey, message));
                this.currentBufferSize += (long)message.length;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("maxBufferSize = {} B, currentBufferSize = {} B, messageSize = {} B", new Object[]{this.maxBufferSizeBytes, this.currentBufferSize, message.length});
            }
        }
    }

    private boolean isBufferTooFull(byte[] message) {
        return this.currentBufferSize + (long)message.length > this.maxBufferSizeBytes;
    }

    private void handleFull(String routingKey, byte[] message) {
        if (this.isFileBufferEnabled()) {
            this.addToFilePersistence();
            this.add(routingKey, message);
        } else if ((long)message.length <= this.maxBufferSizeBytes) {
            this.removeNextMessage();
            this.add(routingKey, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmqpMessageTuple removeNextMessage() {
        AmqpMessageTuple removedMessage;
        Queue<AmqpMessageTuple> queue = this.buffer;
        synchronized (queue) {
            removedMessage = this.buffer.remove();
            this.currentBufferSize -= (long)removedMessage.getMessage().length;
        }
        return removedMessage;
    }

    private void addToFilePersistence() {
        logger.debug("moving buffered messages from RAM to file");
        while (!this.isEmpty()) {
            AmqpMessageTuple messageTuple = this.removeNextMessage();
            this.writeBufferToFile(messageTuple);
        }
        this.currentBufferSize = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBufferToFile(AmqpMessageTuple messageTuple) {
        try {
            FilePersistence filePersistence = this.filePersistence;
            synchronized (filePersistence) {
                this.filePersistence.writeBufferToFile(messageTuple.getRoutingKey(), messageTuple.getMessage());
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public String[] getBuffers() {
        String[] buffers = this.isFileBufferEnabled() ? this.filePersistence.getBuffers() : new String[]{};
        return buffers;
    }

    public Iterator<AmqpMessageTuple> getMessageIterator(String buffer) {
        return new AmqpBufferMessageIterator(buffer, this.filePersistence);
    }

    public void persist() {
        if (this.isFileBufferEnabled()) {
            try {
                this.filePersistence.restructure();
                this.addToFilePersistence();
            }
            catch (IOException e) {
                logger.error("Buffer file restructuring error: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

