/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.amqp;

import java.util.Iterator;
import org.openmuc.framework.lib.amqp.AmqpMessageTuple;
import org.openmuc.framework.lib.filePersistence.FilePersistence;

public class AmqpBufferMessageIterator
implements Iterator<AmqpMessageTuple> {
    private final FilePersistence filePersistence;
    private final String buffer;

    public AmqpBufferMessageIterator(String buffer, FilePersistence filePersistence) {
        this.buffer = buffer;
        this.filePersistence = filePersistence;
    }

    @Override
    public boolean hasNext() {
        return this.filePersistence.fileExistsFor(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmqpMessageTuple next() {
        byte[] message;
        FilePersistence filePersistence = this.filePersistence;
        synchronized (filePersistence) {
            message = this.filePersistence.getMessage(this.buffer);
        }
        return new AmqpMessageTuple(this.buffer, message);
    }
}

