/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.amqp;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.impl.ForgivingExceptionHandler;
import java.net.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AmqpExceptionHandler
extends ForgivingExceptionHandler
implements ExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(AmqpExceptionHandler.class);

    AmqpExceptionHandler() {
    }

    public void handleUnexpectedConnectionDriverException(Connection conn, Throwable exception) {
        logger.error("[{}:{}] Exception detected: {}", new Object[]{conn.getAddress().getHostName(), conn.getPort(), exception.getMessage()});
    }

    public void handleConnectionRecoveryException(Connection conn, Throwable exception) {
        if (!(exception instanceof ConnectException)) {
            logger.error("[{}:{}] Exception in recovery: {}", new Object[]{conn.getAddress().getHostName(), conn.getPort(), exception.toString()});
        }
    }
}

