/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.amqp;

import com.rabbitmq.client.DeliverCallback;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openmuc.framework.lib.amqp.AmqpConnection;
import org.openmuc.framework.lib.amqp.AmqpMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpReader {
    private final Logger logger = LoggerFactory.getLogger(AmqpReader.class);
    private final AmqpConnection connection;
    private final List<Listener> listeners = new ArrayList<Listener>();

    public AmqpReader(AmqpConnection connection) {
        connection.addReader(this);
        this.connection = connection;
    }

    public byte[] read(String queue) {
        GetResponse response;
        this.connection.ensureConnected(false);
        try {
            this.connection.declareQueue(queue);
        }
        catch (IOException e) {
            this.logger.error("Declaring queue failed: {}", (Object)e.getMessage());
            return null;
        }
        try {
            response = this.connection.getRabbitMqChannel().basicGet(queue, true);
        }
        catch (IOException e) {
            this.logger.error("Could not receive message: {}", (Object)e.getMessage());
            return null;
        }
        if (response == null) {
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("message on queue {} received, payload: {}", (Object)queue, (Object)new String(response.getBody()));
        }
        return response.getBody();
    }

    public void listen(Collection<String> queues, AmqpMessageListener listener) {
        this.connection.ensureConnected(false);
        this.listeners.add(new Listener(queues, listener));
        for (String queue : queues) {
            DeliverCallback deliverCallback = (consumerTag, message) -> {
                listener.newMessage(queue, message.getBody());
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("message on queue {} received, payload: {}", (Object)queue, (Object)new String(message.getBody()));
                }
            };
            if (!this.connection.isConnected()) continue;
            try {
                this.connection.declareQueue(queue);
            }
            catch (IOException e) {
                this.logger.error("Declaring queue failed: {}", (Object)e.getMessage());
                continue;
            }
            try {
                this.connection.getRabbitMqChannel().basicConsume(queue, true, deliverCallback, consumerTag -> {});
            }
            catch (IOException e) {
                this.logger.error("Could not subscribe for messages: {}", (Object)e.getMessage());
            }
        }
    }

    void resubscribe() {
        ArrayList<Listener> listenersCopy = new ArrayList<Listener>(this.listeners);
        this.listeners.clear();
        for (Listener listener : listenersCopy) {
            this.listen(listener.queues, listener.listener);
        }
    }

    private static class Listener {
        private final Collection<String> queues;
        private final AmqpMessageListener listener;

        private Listener(Collection<String> queues, AmqpMessageListener listener) {
            this.queues = queues;
            this.listener = listener;
        }
    }
}

