/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.amqp;

import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import java.util.Iterator;
import org.openmuc.framework.lib.amqp.AmqpBufferHandler;
import org.openmuc.framework.lib.amqp.AmqpConnection;
import org.openmuc.framework.lib.amqp.AmqpMessageTuple;
import org.openmuc.framework.lib.amqp.AmqpSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpWriter {
    private static final Logger logger = LoggerFactory.getLogger(AmqpWriter.class);
    private final AmqpBufferHandler bufferHandler;
    private final AmqpConnection connection;
    private final String pid;

    public AmqpWriter(AmqpConnection connection, String pid) {
        this.connection = connection;
        this.pid = pid;
        AmqpSettings s = connection.getSettings();
        this.bufferHandler = new AmqpBufferHandler(s.getMaxBufferSize(), s.getMaxFileCount(), s.getMaxFileSize(), s.getPersistenceDirectory());
        connection.addRecoveryListener(new RecoveryListener(){

            public void handleRecovery(Recoverable recoverable) {
                AmqpWriter.this.emptyFileBuffer();
                AmqpWriter.this.emptyRAMBuffer();
            }

            public void handleRecoveryStarted(Recoverable recoverable) {
            }
        });
        if (connection.isConnected()) {
            this.emptyFileBuffer();
            this.emptyRAMBuffer();
        }
    }

    private void emptyFileBuffer() {
        String[] buffers = this.bufferHandler.getBuffers();
        logger.debug("[{}] Clearing file buffer.", (Object)this.pid);
        if (buffers.length == 0) {
            logger.debug("[{}] File buffer already empty.", (Object)this.pid);
        }
        for (String buffer : buffers) {
            Iterator<AmqpMessageTuple> iterator = this.bufferHandler.getMessageIterator(buffer);
            while (iterator.hasNext()) {
                AmqpMessageTuple messageTuple = iterator.next();
                if (logger.isTraceEnabled()) {
                    logger.trace("[{}] Resend from file: {}", (Object)this.pid, (Object)new String(messageTuple.getMessage()));
                }
                this.write(messageTuple.getRoutingKey(), messageTuple.getMessage());
            }
        }
        logger.debug("[{}] File buffer cleared.", (Object)this.pid);
    }

    private void emptyRAMBuffer() {
        logger.debug("[{}] Clearing RAM buffer.", (Object)this.pid);
        if (this.bufferHandler.isEmpty()) {
            logger.debug("[{}] RAM buffer already empty.", (Object)this.pid);
        }
        while (!this.bufferHandler.isEmpty()) {
            AmqpMessageTuple messageTuple = this.bufferHandler.removeNextMessage();
            if (logger.isTraceEnabled()) {
                logger.trace("[{}] Resend from memory: {}", (Object)this.pid, (Object)new String(messageTuple.getMessage()));
            }
            this.write(messageTuple.getRoutingKey(), messageTuple.getMessage());
        }
        logger.debug("[{}] RAM buffer cleared.", (Object)this.pid);
    }

    public void write(String routingKey, byte[] message) {
        this.connection.ensureConnected(false);
        if (!this.publish(routingKey, message)) {
            this.bufferHandler.add(routingKey, message);
        }
    }

    private boolean publish(String routingKey, byte[] message) {
        try {
            this.connection.declareQueue(routingKey);
            this.connection.getRabbitMqChannel().basicPublish(this.connection.getExchange(), routingKey, false, null, message);
        }
        catch (Exception e) {
            logger.error("[{}] Could not publish message: {}", (Object)this.pid, (Object)e.getMessage());
            this.connection.ensureConnected(true);
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[{}] published with routingKey {}, payload: {}", new Object[]{this.pid, routingKey, new String(message)});
        }
        return true;
    }

    public void shutdown() {
        logger.debug("[{}] Saving buffers.", (Object)this.pid);
        this.bufferHandler.persist();
    }
}

