/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.mqtt;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.openmuc.framework.lib.filePersistence.FilePersistence;
import org.openmuc.framework.lib.mqtt.MessageTuple;
import org.openmuc.framework.lib.mqtt.MqttBufferMessageIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttBufferHandler {
    private static final Logger logger = LoggerFactory.getLogger(MqttBufferHandler.class);
    private final Queue<MessageTuple> buffer = new LinkedList<MessageTuple>();
    private final long maxBufferSizeBytes;
    private long currentBufferSize = 0L;
    private final int maxFileCount;
    private final FilePersistence filePersistence;

    public MqttBufferHandler(long maxBufferSizeKb, int maxFileCount, long maxFileSizeKb, String persistenceDirectory) {
        this.maxBufferSizeBytes = maxBufferSizeKb * 1024L;
        this.maxFileCount = maxFileCount;
        this.filePersistence = this.isFileBufferEnabled() ? new FilePersistence(persistenceDirectory, maxFileCount, maxFileSizeKb) : null;
    }

    private boolean isFileBufferEnabled() {
        return this.maxFileCount > 0 && this.maxBufferSizeBytes > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String topic, byte[] message) {
        if (this.isBufferTooFull(message)) {
            this.handleFull(topic, message);
        } else {
            Queue<MessageTuple> queue = this.buffer;
            synchronized (queue) {
                this.buffer.add(new MessageTuple(topic, message));
                this.currentBufferSize += (long)message.length;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("maxBufferSize = {}, currentBufferSize = {}, messageSize = {}", new Object[]{this.maxBufferSizeBytes, this.currentBufferSize, message.length});
            }
        }
    }

    private boolean isBufferTooFull(byte[] message) {
        return this.currentBufferSize + (long)message.length > this.maxBufferSizeBytes;
    }

    private void handleFull(String topic, byte[] message) {
        if (this.isFileBufferEnabled()) {
            this.addToFilePersistence();
            this.add(topic, message);
        } else if ((long)message.length <= this.maxBufferSizeBytes) {
            this.removeNextMessage();
            this.add(topic, message);
        }
    }

    private void addToFilePersistence() {
        logger.debug("move buffered messages from RAM to file");
        while (!this.buffer.isEmpty()) {
            MessageTuple messageTuple = this.removeNextMessage();
            this.writeBufferToFile(messageTuple);
        }
        this.currentBufferSize = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBufferToFile(MessageTuple messageTuple) {
        try {
            FilePersistence filePersistence = this.filePersistence;
            synchronized (filePersistence) {
                this.filePersistence.writeBufferToFile(messageTuple.topic, messageTuple.message);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageTuple removeNextMessage() {
        MessageTuple removedMessage;
        Queue<MessageTuple> queue = this.buffer;
        synchronized (queue) {
            removedMessage = this.buffer.remove();
            this.currentBufferSize -= (long)removedMessage.message.length;
        }
        return removedMessage;
    }

    public String[] getBuffers() {
        String[] buffers = this.isFileBufferEnabled() ? this.filePersistence.getBuffers() : new String[]{};
        return buffers;
    }

    public Iterator<MessageTuple> getMessageIterator(String buffer) {
        return new MqttBufferMessageIterator(buffer, this.filePersistence);
    }

    public void persist() {
        if (this.isFileBufferEnabled()) {
            try {
                this.filePersistence.restructure();
                this.addToFilePersistence();
            }
            catch (IOException e) {
                logger.error("Buffer file restructuring error: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

