/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.mqtt;

import java.util.Iterator;
import org.openmuc.framework.lib.filePersistence.FilePersistence;
import org.openmuc.framework.lib.mqtt.MessageTuple;

public class MqttBufferMessageIterator
implements Iterator<MessageTuple> {
    private final FilePersistence filePersistence;
    private final String buffer;

    public MqttBufferMessageIterator(String buffer, FilePersistence filePersistence) {
        this.buffer = buffer;
        this.filePersistence = filePersistence;
    }

    @Override
    public boolean hasNext() {
        return this.filePersistence.fileExistsFor(this.buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageTuple next() {
        byte[] message;
        FilePersistence filePersistence = this.filePersistence;
        synchronized (filePersistence) {
            message = this.filePersistence.getMessage(this.buffer);
        }
        return new MessageTuple(this.buffer, message);
    }
}

