/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.mqtt;

import com.hivemq.client.mqtt.MqttClientSslConfig;
import com.hivemq.client.mqtt.MqttClientSslConfigBuilder;
import com.hivemq.client.mqtt.MqttClientTransportConfig;
import com.hivemq.client.mqtt.MqttClientTransportConfigBuilder;
import com.hivemq.client.mqtt.lifecycle.MqttClientAutoReconnectBuilder;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.mqtt3.Mqtt3AsyncClient;
import com.hivemq.client.mqtt.mqtt3.Mqtt3Client;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3Connect;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3PublishBuilder;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3WillPublishBuilder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.openmuc.framework.lib.mqtt.MqttSettings;
import org.openmuc.framework.security.SslManagerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttConnection {
    private static final Logger logger = LoggerFactory.getLogger(MqttConnection.class);
    private final MqttSettings settings;
    private final List<MqttClientConnectedListener> connectedListeners = new ArrayList<MqttClientConnectedListener>();
    private final List<MqttClientDisconnectedListener> disconnectedListeners = new ArrayList<MqttClientDisconnectedListener>();
    private boolean sslReady = false;
    private Mqtt3ClientBuilder clientBuilder;
    private Mqtt3AsyncClient client;
    private SslManagerInterface sslManager = null;
    private Timer connectionWatch = new Timer();

    public MqttConnection(MqttSettings settings) {
        this.settings = settings;
        logger.trace("Init with settings {}", (Object)settings);
        this.clientBuilder = this.getClientBuilder();
        this.client = this.buildClient();
        this.addDisconnectedListener(context -> logger.debug("Disconnection (UUID={}) cause: {} / source {}. Will reconnect: {}", new Object[]{context.getClientConfig().getClientIdentifier().map(Object::toString).orElse("none"), context.getCause(), context.getSource(), context.getReconnector().isReconnect()}));
        this.addConnectedListener(context -> logger.debug("Reconnected (UUID={})", (Object)context.getClientConfig().getClientIdentifier().map(Object::toString).orElse("none")));
    }

    private Mqtt3ClientBuilder getClientBuilder() {
        Mqtt3ClientBuilder clientBuilder = (Mqtt3ClientBuilder)((MqttClientAutoReconnectBuilder.Nested)((MqttClientAutoReconnectBuilder.Nested)((Mqtt3ClientBuilder)Mqtt3Client.builder().identifier(UUID.randomUUID().toString())).automaticReconnect().initialDelay(this.settings.getConnectionRetryInterval(), TimeUnit.SECONDS)).maxDelay(this.settings.getConnectionRetryInterval(), TimeUnit.SECONDS)).applyAutomaticReconnect();
        MqttClientTransportConfigBuilder transportConfigBuilder = this.getTransportConfig();
        MqttClientTransportConfig transportConfig = this.settings.isSsl() && this.sslManager != null ? this.addSslConfig(transportConfigBuilder).build() : transportConfigBuilder.build();
        clientBuilder.transportConfig(transportConfig);
        if (this.settings.isWebSocket()) {
            clientBuilder.webSocketWithDefaultConfig();
        }
        return clientBuilder;
    }

    private MqttClientTransportConfigBuilder getTransportConfig() {
        MqttClientTransportConfigBuilder transportConfigBuilder = MqttClientTransportConfig.builder();
        this.settings.applyProxy(transportConfigBuilder);
        return (MqttClientTransportConfigBuilder)((MqttClientTransportConfigBuilder)((MqttClientTransportConfigBuilder)((MqttClientTransportConfigBuilder)transportConfigBuilder.serverHost(this.settings.getHost())).serverPort(this.settings.getPort())).localPort(this.settings.getLocalPort())).localAddress(this.settings.getLocalAddress());
    }

    private Mqtt3AsyncClient buildClient() {
        return this.clientBuilder.buildAsync();
    }

    private MqttClientTransportConfigBuilder addSslConfig(MqttClientTransportConfigBuilder transportConfigBuilder) {
        MqttClientSslConfig sslConfig = ((MqttClientSslConfigBuilder)((MqttClientSslConfigBuilder)((MqttClientSslConfigBuilder)MqttClientSslConfig.builder().keyManagerFactory(this.sslManager.getKeyManagerFactory())).trustManagerFactory(this.sslManager.getTrustManagerFactory())).handshakeTimeout(10L, TimeUnit.SECONDS)).build();
        transportConfigBuilder.sslConfig(sslConfig);
        return transportConfigBuilder;
    }

    public boolean isReady() {
        if (this.settings.isSsl()) {
            return this.sslReady;
        }
        return true;
    }

    private void sslUpdate() {
        logger.warn("SSL configuration changed, reconnecting.");
        this.sslReady = true;
        this.client.disconnect().whenComplete((ack, e) -> {
            this.clientBuilder.transportConfig(this.addSslConfig(this.getTransportConfig()).build());
            this.clientBuilder.identifier(UUID.randomUUID().toString());
            this.connect();
        });
    }

    private Mqtt3Connect getConnect() {
        Mqtt3ConnectBuilder connectBuilder = Mqtt3Connect.builder();
        connectBuilder.keepAlive(this.settings.getConnectionAliveInterval());
        if (this.settings.isLastWillSet()) {
            ((Mqtt3WillPublishBuilder.Nested.Complete)((Mqtt3WillPublishBuilder.Nested.Complete)connectBuilder.willPublish().topic(this.settings.getLastWillTopic())).payload(this.settings.getLastWillPayload())).applyWillPublish();
        }
        if (this.settings.getUsername() != null) {
            ((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)connectBuilder.simpleAuth().username(this.settings.getUsername())).password(this.settings.getPassword().getBytes())).applySimpleAuth();
        }
        return connectBuilder.build();
    }

    public void connect() {
        this.client = this.buildClient();
        String uuid = this.client.getConfig().getClientIdentifier().map(Object::toString).orElse("<no uuid>");
        logger.trace("Client {} connecting to server {}", (Object)uuid, (Object)this.settings.getHost());
        LocalDateTime time = LocalDateTime.now();
        this.client.connect(this.getConnect()).whenComplete((ack, e) -> {
            if (e != null) {
                if (uuid.equals(this.client.getConfig().getClientIdentifier().toString())) {
                    logger.error("Error with connection initiated at {}: {}", (Object)time, (Object)e.getMessage());
                } else {
                    logger.warn("Error with some old connection with UUID={}", (Object)uuid, e);
                }
            } else {
                logger.debug("connect successfully");
            }
        });
        this.watchConnection();
    }

    private void watchConnection() {
        logger.trace("Resetting previous connection watch tasks (if present)");
        this.connectionWatch.cancel();
        this.connectionWatch = new Timer();
        final long periodMillis = this.settings.getConnectionRetryInterval() * 1000L;
        TimerTask connectionWatchTask = new TimerTask(){
            AtomicInteger disconnectedCount = new AtomicInteger(0);

            @Override
            public void run() {
                boolean connected = MqttConnection.this.client.getState().isConnected();
                boolean connectedOrReconnect = MqttConnection.this.client.getState().isConnectedOrReconnect();
                String clientIdentifier = MqttConnection.this.client.getConfig().getClientIdentifier().map(Object::toString).orElse("<none>");
                logger.debug("Client (identifier={}, host={}) state: connected={}, connectedOrReconnect={}", new Object[]{clientIdentifier, MqttConnection.this.settings.getHost(), connected, connectedOrReconnect});
                if (connectedOrReconnect) {
                    logger.debug("Is connectedOrReconnect");
                    this.disconnectedCount.set(0);
                } else {
                    int disconnectedSince = this.disconnectedCount.incrementAndGet();
                    logger.debug("Is now disconnected since {} runs", (Object)disconnectedSince);
                }
                long disconnectedCnt = 10L;
                if ((long)this.disconnectedCount.get() > 10L) {
                    logger.info("Was disconnected for more than {}ms. Starting manual reconnect by creating a new client, disconnecting old client", (Object)(periodMillis * 10L));
                    MqttConnection.this.client.disconnect();
                    String newIdentifier = UUID.randomUUID().toString();
                    MqttConnection.this.clientBuilder.identifier(newIdentifier);
                    MqttConnection.this.connect();
                }
            }
        };
        this.connectionWatch.scheduleAtFixedRate(connectionWatchTask, 0L, periodMillis);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.connectionWatch.cancel();
            logger.debug("Shut down connection watch timer");
        }));
        logger.trace("Watching connection");
    }

    public void disconnect() {
        if (this.settings.isLastWillAlways()) {
            ((CompletableFuture)((Mqtt3PublishBuilder.Send.Complete)((Mqtt3PublishBuilder.Send.Complete)this.client.publishWith().topic(this.settings.getLastWillTopic())).payload(this.settings.getLastWillPayload())).send()).whenComplete((publish, e) -> this.client.disconnect());
        } else {
            this.client.disconnect();
        }
    }

    void addConnectedListener(MqttClientConnectedListener listener) {
        logger.trace("addConnectedListener ");
        if (this.clientBuilder == null) {
            this.connectedListeners.add(listener);
        } else {
            this.clientBuilder.addConnectedListener(listener);
            if (!this.connectedListeners.contains(listener)) {
                this.connectedListeners.add(listener);
            }
        }
    }

    void addDisconnectedListener(MqttClientDisconnectedListener listener) {
        logger.trace("addDisconnectedListener");
        if (this.clientBuilder == null) {
            this.disconnectedListeners.add(listener);
        } else {
            this.clientBuilder.addDisconnectedListener(listener);
            if (!this.disconnectedListeners.contains(listener)) {
                this.disconnectedListeners.add(listener);
            }
        }
    }

    Mqtt3AsyncClient getClient() {
        return this.client;
    }

    public MqttSettings getSettings() {
        return this.settings;
    }

    public void setSslManager(SslManagerInterface instance) {
        if (!this.settings.isSsl()) {
            return;
        }
        this.sslManager = instance;
        this.clientBuilder = this.getClientBuilder();
        for (MqttClientConnectedListener mqttClientConnectedListener : this.connectedListeners) {
            this.addConnectedListener(mqttClientConnectedListener);
        }
        this.connectedListeners.clear();
        for (MqttClientDisconnectedListener mqttClientDisconnectedListener : this.disconnectedListeners) {
            this.addDisconnectedListener(mqttClientDisconnectedListener);
        }
        this.disconnectedListeners.clear();
        this.sslManager.listenForConfigChange(this::sslUpdate);
        this.addDisconnectedListener(context -> {
            logger.debug("Handling disconnect");
            String disconnectedClientId = context.getClientConfig().getClientIdentifier().map(Object::toString).orElse("<no id from context>");
            String thisClientIdentifier = this.client.getConfig().getClientIdentifier().map(Object::toString).orElse("<no id from client>");
            if (!disconnectedClientId.equals(thisClientIdentifier)) {
                logger.debug("Old client was disconnected. Preventing further reconnects.");
                context.getReconnector().reconnect(false);
            } else if (context.getReconnector().getAttempts() >= 3) {
                logger.debug("Shutting down old client");
                context.getReconnector().reconnect(false);
                this.client.disconnect();
                logger.info("Disconnected old client {}, starting new client", (Object)thisClientIdentifier);
                String newIdentifier = UUID.randomUUID().toString();
                this.clientBuilder.identifier(newIdentifier);
                this.connect();
                logger.debug("Connected to new client {}", (Object)newIdentifier);
            }
        });
        this.client = this.buildClient();
        if (this.sslManager.isLoaded()) {
            this.sslReady = true;
        }
    }
}

