/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.mqtt;

import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscribe;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3SubscribeBuilder;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3Subscription;
import com.hivemq.client.mqtt.mqtt3.message.subscribe.Mqtt3SubscriptionBuilder;
import java.util.LinkedList;
import java.util.List;
import org.openmuc.framework.lib.mqtt.MqttConnection;
import org.openmuc.framework.lib.mqtt.MqttMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class MqttReader {
    private static final Logger logger = LoggerFactory.getLogger(MqttReader.class);
    private final MqttConnection connection;
    private boolean connected = false;
    private final List<SubscribeListenerTuple> subscribes = new LinkedList<SubscribeListenerTuple>();
    private final String pid;

    public MqttReader(MqttConnection connection, String pid) {
        this.connection = connection;
        this.pid = pid;
        this.addConnectedListener(connection);
        this.addDisconnectedListener(connection);
    }

    private void addDisconnectedListener(MqttConnection connection) {
        connection.addDisconnectedListener(context -> {
            if (context.getReconnector().isReconnect()) {
                if (this.connected) {
                    this.warn("Disconnected! {}", context.getCause().getMessage());
                } else {
                    this.warn("Reconnect failed! Reason: {}", context.getCause().getMessage());
                }
                this.connected = false;
            }
        });
    }

    private void addConnectedListener(MqttConnection connection) {
        connection.addConnectedListener(context -> {
            for (SubscribeListenerTuple tuple : this.subscribes) {
                this.subscribe(tuple.subscribe, tuple.listener);
            }
            this.connected = true;
            this.log("Connected to {}:{}", context.getClientConfig().getServerHost(), context.getClientConfig().getServerPort());
        });
    }

    public void listen(List<String> topics, MqttMessageListener listener) {
        Mqtt3Subscribe subscribe = this.buildSubscribe(topics);
        if (subscribe == null) {
            this.error("No topic given to listen on", new Object[0]);
            return;
        }
        if (this.connected) {
            this.subscribe(subscribe, listener);
        }
        this.subscribes.add(new SubscribeListenerTuple(subscribe, listener));
    }

    private void subscribe(Mqtt3Subscribe subscribe, MqttMessageListener listener) {
        this.connection.getClient().subscribe(subscribe, mqtt3Publish -> {
            listener.newMessage(mqtt3Publish.getTopic().toString(), mqtt3Publish.getPayloadAsBytes());
            if (logger.isTraceEnabled()) {
                this.trace("Message on topic {} received, payload: {}", mqtt3Publish.getTopic().toString(), new String(mqtt3Publish.getPayloadAsBytes()));
            }
        });
    }

    private Mqtt3Subscribe buildSubscribe(List<String> topics) {
        Mqtt3SubscribeBuilder.Start subscribeBuilder = Mqtt3Subscribe.builder();
        Mqtt3Subscribe subscribe = null;
        for (String topic : topics) {
            Mqtt3Subscription subscription = ((Mqtt3SubscriptionBuilder.Complete)Mqtt3Subscription.builder().topicFilter(topic)).build();
            if (topics.get(topics.size() - 1).equals(topic)) {
                subscribe = ((Mqtt3SubscribeBuilder.Complete)subscribeBuilder.addSubscription(subscription)).build();
                break;
            }
            subscribeBuilder.addSubscription(subscription);
        }
        return subscribe;
    }

    private void log(String message, Object ... args) {
        message = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        logger.info("[{}] {}", (Object)this.pid, (Object)message);
    }

    private void debug(String message, Object ... args) {
        message = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        logger.debug("[{}] {}", (Object)this.pid, (Object)message);
    }

    private void warn(String message, Object ... args) {
        message = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        logger.warn("[{}] {}", (Object)this.pid, (Object)message);
    }

    private void error(String message, Object ... args) {
        message = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        logger.error("[{}] {}", (Object)this.pid, (Object)message);
    }

    private void trace(String message, Object ... args) {
        message = MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage();
        logger.trace("[{}] {}", (Object)this.pid, (Object)message);
    }

    private static class SubscribeListenerTuple {
        private final Mqtt3Subscribe subscribe;
        private final MqttMessageListener listener;

        private SubscribeListenerTuple(Mqtt3Subscribe subscribe, MqttMessageListener listener) {
            this.subscribe = subscribe;
            this.listener = listener;
        }
    }
}

