/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.mqtt;

import com.hivemq.client.mqtt.MqttClientTransportConfigBuilder;
import com.hivemq.client.mqtt.MqttProxyConfig;
import com.hivemq.client.mqtt.MqttProxyConfigBuilder;
import com.hivemq.client.mqtt.MqttProxyProtocol;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSettings {
    private static final Logger logger = LoggerFactory.getLogger(MqttSettings.class);
    private final String host;
    private final int port;
    private final int localPort;
    private final String localAddress;
    private final String username;
    private final String password;
    private final boolean ssl;
    private final long maxBufferSize;
    private final long maxFileSize;
    private final int maxFileCount;
    private final int connectionRetryInterval;
    private final int connectionAliveInterval;
    private final String persistenceDirectory;
    private final String lastWillTopic;
    private final byte[] lastWillPayload;
    private final boolean lastWillAlways;
    private final String firstWillTopic;
    private final byte[] firstWillPayload;
    private final int recoveryChunkSize;
    private final int recoveryDelay;
    private final boolean webSocket;
    private final boolean retainedMessages;
    private final Optional<ProxySettings> proxySettings;
    private final String parser;

    public MqttSettings(String host, int port, int localPort, String localAddress, String username, String password, boolean ssl, long maxBufferSize, long maxFileSize, int maxFileCount, int connectionRetryInterval, int connectionAliveInterval, String persistenceDirectory, String lastWillTopic, byte[] lastWillPayload, boolean lastWillAlways, String firstWillTopic, byte[] firstWillPayload, int recoveryChunkSize, int recoveryDelay, boolean webSocket, boolean retainedMessages, String httpProxyConfig, String parser) {
        this.host = host;
        this.port = port;
        this.localPort = localPort;
        this.localAddress = localAddress;
        this.username = username;
        this.password = password;
        this.ssl = ssl;
        this.webSocket = webSocket;
        this.maxBufferSize = maxBufferSize;
        this.maxFileSize = maxFileSize;
        this.maxFileCount = maxFileCount;
        this.connectionRetryInterval = connectionRetryInterval;
        this.connectionAliveInterval = connectionAliveInterval;
        this.persistenceDirectory = persistenceDirectory;
        this.lastWillTopic = lastWillTopic;
        this.lastWillPayload = lastWillPayload;
        this.lastWillAlways = lastWillAlways;
        this.firstWillTopic = firstWillTopic;
        this.firstWillPayload = firstWillPayload;
        this.recoveryChunkSize = recoveryChunkSize;
        this.recoveryDelay = recoveryDelay;
        this.retainedMessages = retainedMessages;
        this.proxySettings = ProxySettings.parse(httpProxyConfig);
        this.parser = parser;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public long getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public int getMaxFileCount() {
        return this.maxFileCount;
    }

    public long getConnectionRetryInterval() {
        return this.connectionRetryInterval;
    }

    public int getConnectionAliveInterval() {
        return this.connectionAliveInterval;
    }

    public String getPersistenceDirectory() {
        return this.persistenceDirectory;
    }

    public String getLastWillTopic() {
        return this.lastWillTopic;
    }

    public byte[] getLastWillPayload() {
        return this.lastWillPayload;
    }

    public boolean isLastWillSet() {
        return !this.lastWillTopic.equals("") && this.lastWillPayload.length != 0;
    }

    public boolean isLastWillAlways() {
        return this.lastWillAlways && this.isLastWillSet();
    }

    public String getFirstWillTopic() {
        return this.firstWillTopic;
    }

    public byte[] getFirstWillPayload() {
        return this.firstWillPayload;
    }

    public boolean isFirstWillSet() {
        return !this.firstWillTopic.equals("") && this.lastWillPayload.length != 0;
    }

    public boolean isRecoveryLimitSet() {
        return this.recoveryChunkSize > 0 && this.recoveryDelay > 0;
    }

    public int getRecoveryChunkSize() {
        return this.recoveryChunkSize;
    }

    public int getRecoveryDelay() {
        return this.recoveryDelay;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    public boolean isRetainedMessages() {
        return this.retainedMessages;
    }

    public boolean hasSupportedProxyConfigured() {
        return this.proxySettings.isPresent();
    }

    public String getParser() {
        return this.parser;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("host=").append(this.getHost()).append("\n");
        sb.append("port=").append(this.getPort()).append("\n");
        sb.append("localPort=").append(this.getLocalPort()).append("\n");
        sb.append("localAddress=").append(this.getLocalAddress()).append("\n");
        sb.append("username=").append(this.getUsername()).append("\n");
        sb.append("password=").append("*****").append("\n");
        sb.append("ssl=").append(this.isSsl()).append("\n");
        sb.append("webSocket=").append(this.isWebSocket()).append("\n");
        sb.append("retainedMessages=").append(this.isRetainedMessages()).append("\n");
        sb.append("persistenceDirectory=").append(this.getPersistenceDirectory()).append("\n");
        sb.append("maxBufferSize=").append(this.getMaxBufferSize()).append("\n");
        sb.append("maxFileCount=").append(this.getMaxFileCount()).append("\n");
        sb.append("maxFileSize=").append(this.getMaxFileSize()).append("\n");
        sb.append("connectionRetryInterval=").append(this.getConnectionRetryInterval()).append("\n");
        sb.append("connectionAliveInterval=").append(this.getConnectionAliveInterval()).append("\n");
        sb.append("lastWillTopic=").append(this.getLastWillTopic()).append("\n");
        sb.append("lastWillPayload=").append(new String(this.getLastWillPayload())).append("\n");
        sb.append("lastWillAlways=").append(this.isLastWillAlways()).append("\n");
        sb.append("firstWillTopic=").append(this.getFirstWillTopic()).append("\n");
        sb.append("firstWillPayload=").append(new String(this.getFirstWillPayload()));
        sb.append("recoveryChunkSize=").append(this.getRecoveryChunkSize()).append("\n");
        sb.append("recoveryDelay=").append(this.getRecoveryDelay()).append("\n");
        return sb.toString();
    }

    public Optional<ProxySettings> getProxySettings() {
        return this.proxySettings;
    }

    public void applyProxy(MqttClientTransportConfigBuilder transportConfigBuilder) {
        if (this.proxySettings.isPresent()) {
            transportConfigBuilder.proxyConfig(this.proxySettings.get().toMqttProxyConfig());
            logger.debug("Applied proxy settings");
        } else {
            logger.debug("No proxy set");
        }
    }

    public static enum ProxyProtocolMapping {
        HTTP("http", MqttProxyProtocol.HTTP),
        SOCKS_4("socks4", MqttProxyProtocol.SOCKS_4),
        SOCKS_5("socks5", MqttProxyProtocol.SOCKS_5);

        String schema;
        MqttProxyProtocol mqttProxyProtocol;

        private ProxyProtocolMapping(String schema, MqttProxyProtocol protocol) {
            this.schema = schema;
            this.mqttProxyProtocol = protocol;
        }

        public String getSchema() {
            return this.schema;
        }

        static ProxyProtocolMapping parse(URI uri) {
            Optional<ProxyProtocolMapping> existingMapping = Arrays.stream(ProxyProtocolMapping.values()).filter(mapping -> uri.getScheme().startsWith(mapping.getSchema())).findFirst();
            return existingMapping.orElseThrow(() -> new IllegalArgumentException("Unknown proxy schema '" + uri.getScheme() + "'. Known schemes are: " + ProxyProtocolMapping.values()));
        }

        Collection<String> getKnownSchemas() {
            return Arrays.stream(ProxyProtocolMapping.values()).map(ProxyProtocolMapping::getSchema).collect(Collectors.toSet());
        }

        public String toString() {
            return this.getSchema();
        }
    }

    public static class ProxySettings {
        public static String PROXY_HTTP_WITH_USER = "http://user:password@host:port";
        public static String PROXY_HTTP = "http://host:port";
        public static String PROXY_SOCKS4 = "socks4://host:port";
        public static String PROXY_SOCKS5 = "socks5://host:port";
        private final ProxyProtocolMapping protocol;
        private final String hostname;
        private final int port;
        private final Optional<String> user;
        private final Optional<String> password;

        public ProxySettings(ProxyProtocolMapping protocol, String hostname, int port, Optional<String> user, Optional<String> password) {
            this.protocol = protocol;
            this.hostname = hostname;
            this.port = port;
            this.user = user;
            this.password = password;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private ProxySettings(String proxyConfig) {
            String httpProxyStringWithSchema;
            if (proxyConfig.contains("://")) {
                httpProxyStringWithSchema = proxyConfig;
            } else {
                String defaultSchema = ProxyProtocolMapping.HTTP.getSchema() + "://";
                logger.debug("No proxy schema set. Assuming '{}'", (Object)defaultSchema);
                httpProxyStringWithSchema = defaultSchema + proxyConfig;
            }
            try {
                URI uri = new URI(httpProxyStringWithSchema);
                this.protocol = ProxyProtocolMapping.parse(uri);
                if (uri.getHost() == null || uri.getHost().isEmpty()) {
                    throw new IllegalArgumentException("Bad proxy config '" + proxyConfig + "': host is missing");
                }
                this.hostname = uri.getHost();
                this.port = uri.getPort();
                String userInfo = uri.getUserInfo();
                if (userInfo != null && !userInfo.isEmpty() && userInfo.contains(":")) {
                    String[] split = userInfo.split(":");
                    if (split.length != 2) throw new IllegalArgumentException("Bad user/password in proxy settings");
                    this.user = Optional.of(split[0]);
                    this.password = Optional.of(split[1]);
                    return;
                } else {
                    this.user = Optional.empty();
                    this.password = Optional.empty();
                }
                return;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse proxy config from '" + proxyConfig + "'", e);
            }
        }

        public static Optional<ProxySettings> parse(String proxyConfig) throws IllegalArgumentException {
            if ((proxyConfig == null ? "" : proxyConfig).trim().isEmpty()) {
                return Optional.empty();
            }
            try {
                ProxySettings settings = new ProxySettings(proxyConfig);
                logger.debug("Parsed {}", (Object)settings);
                return Optional.of(settings);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to parse MQTT Settings from " + proxyConfig + ". Defaulting to no proxy.", e);
            }
        }

        public MqttProxyConfig toMqttProxyConfig() {
            MqttProxyConfigBuilder proxyConfigBuilder = MqttProxyConfig.builder();
            ((MqttProxyConfigBuilder)((MqttProxyConfigBuilder)proxyConfigBuilder.host(this.hostname)).port(this.port)).protocol(this.protocol.mqttProxyProtocol);
            if (this.user.isPresent()) {
                proxyConfigBuilder.username(this.user.get());
            }
            if (this.password.isPresent()) {
                proxyConfigBuilder.password(this.password.get());
            }
            return proxyConfigBuilder.build();
        }

        public String toString() {
            return "ProxySettings{protocol=" + (Object)((Object)this.protocol) + ", hostname='" + this.hostname + '\'' + ", port=" + this.port + ", user=" + this.user.orElse("<none>") + ", hasPassword=" + this.password.isPresent() + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProxySettings settings = (ProxySettings)o;
            return this.port == settings.port && this.protocol == settings.protocol && Objects.equals(this.hostname, settings.hostname) && Objects.equals(this.user, settings.user) && Objects.equals(this.password, settings.password);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.protocol, this.hostname, this.port, this.user, this.password});
        }
    }
}

