/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.lib.parser.openmuc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Base64;
import java.util.List;
import org.openmuc.framework.data.BooleanValue;
import org.openmuc.framework.data.ByteArrayValue;
import org.openmuc.framework.data.ByteValue;
import org.openmuc.framework.data.DoubleValue;
import org.openmuc.framework.data.Flag;
import org.openmuc.framework.data.FloatValue;
import org.openmuc.framework.data.IntValue;
import org.openmuc.framework.data.LongValue;
import org.openmuc.framework.data.Record;
import org.openmuc.framework.data.ShortValue;
import org.openmuc.framework.data.StringValue;
import org.openmuc.framework.data.Value;
import org.openmuc.framework.data.ValueType;
import org.openmuc.framework.datalogger.spi.LoggingRecord;
import org.openmuc.framework.parser.spi.ParserService;
import org.openmuc.framework.parser.spi.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenmucParserServiceImpl
implements ParserService {
    private final Logger logger = LoggerFactory.getLogger(OpenmucParserServiceImpl.class);
    private final Gson gson;
    private ValueType valueType;

    public OpenmucParserServiceImpl() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Record.class, (Object)new RecordInstanceCreator());
        gsonBuilder.registerTypeAdapter(Value.class, (Object)new ValueDeserializer());
        gsonBuilder.registerTypeAdapter(Record.class, (Object)new RecordAdapter());
        gsonBuilder.disableHtmlEscaping();
        this.gson = gsonBuilder.create();
    }

    public synchronized byte[] serialize(LoggingRecord openMucRecord) {
        String serializedString = this.gson.toJson((Object)openMucRecord.getRecord());
        return serializedString.getBytes();
    }

    public synchronized byte[] serialize(List<LoggingRecord> openMucRecords) throws SerializationException {
        StringBuilder sb = new StringBuilder();
        for (LoggingRecord openMucRecord : openMucRecords) {
            sb.append(new String(this.serialize(openMucRecord)));
            sb.append('\n');
        }
        return sb.toString().getBytes();
    }

    public synchronized Record deserialize(byte[] byteArray, ValueType valueType) {
        this.valueType = valueType;
        return (Record)this.gson.fromJson(new String(byteArray), Record.class);
    }

    private class ValueDeserializer
    implements JsonDeserializer<Value> {
        private ValueDeserializer() {
        }

        public Value deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            switch (OpenmucParserServiceImpl.this.valueType) {
                case BOOLEAN: {
                    return new BooleanValue(json.getAsBoolean());
                }
                case BYTE_ARRAY: {
                    return new ByteArrayValue(Base64.getDecoder().decode(json.getAsString()));
                }
                case BYTE: {
                    return new ByteValue(json.getAsByte());
                }
                case DOUBLE: {
                    return new DoubleValue(json.getAsDouble());
                }
                case FLOAT: {
                    return new FloatValue(json.getAsFloat());
                }
                case INTEGER: {
                    return new IntValue(json.getAsInt());
                }
                case LONG: {
                    return new LongValue(json.getAsLong());
                }
                case SHORT: {
                    return new ShortValue(json.getAsShort());
                }
                case STRING: {
                    return new StringValue(json.getAsString());
                }
            }
            OpenmucParserServiceImpl.this.logger.warn("Unsupported ValueType: {}", (Object)OpenmucParserServiceImpl.this.valueType);
            return null;
        }
    }

    private class RecordAdapter
    implements JsonSerializer<Record> {
        private RecordAdapter() {
        }

        public JsonElement serialize(Record record, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            Value value = record.getValue();
            obj.addProperty("timestamp", (Number)record.getTimestamp());
            obj.addProperty("flag", record.getFlag().toString());
            if (value != null && record.getFlag() == Flag.VALID) {
                String valueString = "value";
                switch (value.getValueType()) {
                    case BOOLEAN: {
                        obj.addProperty(valueString, Boolean.valueOf(record.getValue().asBoolean()));
                        break;
                    }
                    case BYTE: {
                        obj.addProperty(valueString, (Number)record.getValue().asByte());
                        break;
                    }
                    case BYTE_ARRAY: {
                        obj.addProperty(valueString, Base64.getEncoder().encodeToString(record.getValue().asByteArray()));
                        break;
                    }
                    case DOUBLE: {
                        obj.addProperty(valueString, (Number)record.getValue().asDouble());
                        break;
                    }
                    case FLOAT: {
                        obj.addProperty(valueString, (Number)Float.valueOf(record.getValue().asFloat()));
                        break;
                    }
                    case INTEGER: {
                        obj.addProperty(valueString, (Number)record.getValue().asInt());
                        break;
                    }
                    case LONG: {
                        obj.addProperty(valueString, (Number)record.getValue().asLong());
                        break;
                    }
                    case SHORT: {
                        obj.addProperty(valueString, (Number)record.getValue().asShort());
                        break;
                    }
                    case STRING: {
                        obj.addProperty(valueString, record.getValue().asString());
                        break;
                    }
                }
            }
            return obj;
        }
    }

    private class RecordInstanceCreator
    implements InstanceCreator<Record> {
        private RecordInstanceCreator() {
        }

        public Record createInstance(Type type) {
            return new Record(Flag.DISABLED);
        }
    }
}

