/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.config;

import org.openmuc.framework.data.ValueType;

public class ChannelScanInfo {
    private final String channelAddress;
    private final String description;
    private final ValueType valueType;
    private final Integer valueTypeLength;
    private final Boolean readable;
    private final Boolean writable;
    private final String metaData;
    private final String unit;

    public ChannelScanInfo(String channelAddress, String description, ValueType valueType, Integer valueTypeLength) {
        this(channelAddress, description, valueType, valueTypeLength, true, true);
    }

    public ChannelScanInfo(String channelAddress, String description, ValueType valueType, Integer valueTypeLength, Boolean readable, Boolean writable) {
        this(channelAddress, description, valueType, valueTypeLength, readable, writable, "");
    }

    public ChannelScanInfo(String channelAddress, String description, ValueType valueType, Integer valueTypeLength, Boolean readable, Boolean writable, String metaData) {
        this(channelAddress, description, valueType, valueTypeLength, readable, writable, metaData, "");
    }

    public ChannelScanInfo(String channelAddress, String description, ValueType valueType, Integer valueTypeLength, Boolean readable, Boolean writable, String metaData, String unit) {
        if (channelAddress == null || channelAddress.isEmpty()) {
            throw new IllegalArgumentException("Channel Address may not be empty.");
        }
        this.channelAddress = channelAddress;
        this.description = description;
        this.valueType = valueType;
        this.valueTypeLength = valueTypeLength;
        this.readable = readable;
        this.writable = writable;
        this.metaData = metaData;
        this.unit = unit;
    }

    public String getChannelAddress() {
        return this.channelAddress;
    }

    public String getDescription() {
        return this.description;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Integer getValueTypeLength() {
        return this.valueTypeLength;
    }

    public Boolean isReadable() {
        return this.readable;
    }

    public Boolean isWritable() {
        return this.writable;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getUnit() {
        return this.unit;
    }
}

