/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.config;

public class DeviceScanInfo {
    private final String id;
    private final String deviceAddress;
    private final String settings;
    private final String description;

    public DeviceScanInfo(String deviceAddress, String settings, String description) {
        this("", deviceAddress, settings, description);
    }

    public DeviceScanInfo(String id, String deviceAddress, String settings, String description) {
        if (deviceAddress == null) {
            throw new IllegalArgumentException("deviceAddress must not be null.");
        }
        this.id = id == null || id.isEmpty() ? deviceAddress.replaceAll("[^a-zA-Z0-9]+", "") : id;
        this.deviceAddress = deviceAddress;
        this.settings = settings == null ? "" : settings;
        this.description = description == null ? "" : description;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public String getSettings() {
        return this.settings;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nDeviceScanInfo:\n  ID: ").append(this.id).append("\n  DeviceAddress: ").append(this.deviceAddress).append("\n  Settings: ").append(this.settings).append("\n  Description: ").append(this.description);
        return sb.toString();
    }
}

