/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.data;

import org.openmuc.framework.data.Value;
import org.openmuc.framework.data.ValueType;

public class BooleanValue
implements Value {
    private final boolean value;

    public BooleanValue(boolean value) {
        this.value = value;
    }

    public BooleanValue(String value) {
        this.value = Boolean.parseBoolean(value);
    }

    @Override
    public double asDouble() {
        return this.asByte();
    }

    @Override
    public float asFloat() {
        return this.asByte();
    }

    @Override
    public long asLong() {
        return this.asByte();
    }

    @Override
    public int asInt() {
        return this.asByte();
    }

    @Override
    public short asShort() {
        return this.asByte();
    }

    @Override
    public byte asByte() {
        if (this.value) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean asBoolean() {
        return this.value;
    }

    @Override
    public byte[] asByteArray() {
        return new byte[]{this.asByte()};
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public String asString() {
        return this.toString();
    }

    @Override
    public ValueType getValueType() {
        return ValueType.BOOLEAN;
    }
}

