/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.data;

import java.util.HashMap;
import java.util.Map;

public enum Flag {
    VALID(1),
    TIMEOUT(2),
    UNKNOWN_ERROR(3),
    DEVICE_OR_INTERFACE_BUSY(5),
    ACCESS_METHOD_NOT_SUPPORTED(6),
    NO_VALUE_RECEIVED_YET(7),
    CONNECTING(8),
    WAITING_FOR_CONNECTION_RETRY(9),
    DISCONNECTING(10),
    DRIVER_UNAVAILABLE(11),
    SAMPLING_AND_LISTENING_DISABLED(12),
    DISABLED(13),
    CHANNEL_DELETED(14),
    STARTED_LATE_AND_TIMED_OUT(15),
    DRIVER_THREW_UNKNOWN_EXCEPTION(16),
    COMM_DEVICE_NOT_CONNECTED(17),
    DRIVER_ERROR_CHANNEL_ADDRESS_SYNTAX_INVALID(18),
    DRIVER_ERROR_CHANNEL_WITH_THIS_ADDRESS_NOT_FOUND(19),
    DRIVER_ERROR_CHANNEL_NOT_ACCESSIBLE(20),
    DRIVER_ERROR_CHANNEL_TEMPORARILY_NOT_ACCESSIBLE(21),
    DRIVER_ERROR_CHANNEL_VALUE_TYPE_CONVERSION_EXCEPTION(22),
    INFEASIBLE_TO_SAMPLE_CHANNEL_GROUP_IN_ONE_REQUEST(23),
    DRIVER_ERROR_SAMPLING_GROUP_NOT_FOUND(24),
    DRIVER_ERROR_SAMPLING_GROUP_NOT_ACCESSIBLE(25),
    DRIVER_ERROR_CHANNEL_NOT_PART_OF_SAMPLING_GROUP(26),
    CANNOT_WRITE_NULL_VALUE(27),
    DRIVER_ERROR_READ_FAILURE(28),
    CONNECTION_EXCEPTION(29),
    DRIVER_ERROR_TIMEOUT(30),
    DRIVER_ERROR_DECODING_RESPONSE_FAILED(31),
    DATA_LOGGING_NOT_ACTIVE(32),
    DRIVER_ERROR_UNSPECIFIED(33),
    VALUE_IS_NAN(34),
    VALUE_IS_INFINITY(35),
    CUSTOM_ERROR_0(50),
    CUSTOM_ERROR_1(51),
    CUSTOM_ERROR_2(52),
    CUSTOM_ERROR_3(53),
    CUSTOM_ERROR_4(54),
    CUSTOM_ERROR_5(55),
    CUSTOM_ERROR_6(56),
    CUSTOM_ERROR_7(57),
    CUSTOM_ERROR_8(58),
    CUSTOM_ERROR_9(59);

    private final int code;
    private static final Map<Byte, Flag> idMap;

    private Flag(int code) {
        this.code = code;
    }

    public byte getCode() {
        return (byte)this.code;
    }

    public static Flag newFlag(int code) {
        Flag enumInstance = idMap.get((byte)code);
        if (enumInstance == null) {
            throw new IllegalArgumentException("Unknown Flag code: " + code);
        }
        return enumInstance;
    }

    static {
        idMap = new HashMap<Byte, Flag>();
        for (Flag enumInstance : Flag.values()) {
            if (idMap.put(enumInstance.getCode(), enumInstance) == null) continue;
            throw new IllegalArgumentException("duplicate ID: " + enumInstance.getCode());
        }
    }
}

