/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.framework.data;

import org.openmuc.framework.data.Flag;
import org.openmuc.framework.data.Value;

public class Record {
    private final Long timestamp;
    private final Flag flag;
    private final Value value;

    public Record(Value value, Long timestamp, Flag flag) {
        this.value = value;
        this.timestamp = timestamp;
        if (value == null && flag.equals((Object)Flag.VALID)) {
            throw new IllegalArgumentException("If a record's flag is set valid the value may not be NULL.");
        }
        this.flag = flag;
    }

    public Record(Value value, Long timestamp) {
        this(value, timestamp, Flag.VALID);
    }

    public Record(Flag flag) {
        this(null, null, flag);
        if (flag == Flag.VALID) {
            throw new IllegalArgumentException("flag must indicate an error");
        }
    }

    public Value getValue() {
        return this.value;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public String toString() {
        return "value: " + this.value + "; timestamp: " + this.timestamp + "; flag: " + (Object)((Object)this.flag);
    }
}

